<!DOCTYPE html>
<html lang="{{ lang['langcode'] }}">
	<head>
		<meta charset="{{ lang['encoding'] }}"/>
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<title>{{ home_title }}
			-
			{{ lang['admin_panel'] }}</title>
		<link rel="stylesheet" href="{{ skins_url }}/assets/vendor/daterangepicker/daterangepicker.css">
		<link rel="stylesheet" href="{{ skins_url }}/assets/vendor/datetimepicker/jquery.datetimepicker.min.css">
		<link rel="stylesheet" href="{{ skins_url }}/assets/vendor/admin-resources/jquery.vectormap/jquery-jvectormap-1.2.2.css">
		<link href="{{ skins_url }}/public/css/app.min.css" rel="stylesheet" type="text/css" id="app-style"/>
		<link href="{{ skins_url }}/public/css/ng_style.css" rel="stylesheet" type="text/css" id="ng-style"/>
		<link href="{{ skins_url }}/public/css/icons.min.css" rel="stylesheet" type="text/css"/>
		<script src="{{ skins_url }}/public/js/config.js"></script>
		<script src="{{ skins_url }}/public/js/vendor.min.js"></script>
		<script src="{{ skins_url }}/public/js/ngFileTree.js"></script>
		<script src="{{ skins_url }}/public/js/manifest.js" type="text/javascript"></script>
		<script src="{{ skins_url }}/public/js/vendor.js" type="text/javascript"></script>
		<script src="{{ skins_url }}/public/js/app.js" type="text/javascript"></script>
	</head>
	<body>
		<div id="loading-layer" style="display:none">
			{{ lang['loading'] }}
		</div>
		<!-- Begin page -->
		<div
			class="wrapper">
			<!-- ========== Topbar Start ========== -->
			<div class="navbar-custom">
				<div class="topbar container-fluid">
					<div
						class="d-flex align-items-center gap-1">
						<!-- Topbar Brand Logo -->
						<div
							class="logo-topbar">
							<!-- Logo light -->
							<a href="{{ php_self }}" class="logo-light">
								<span class="logo-lg">
									<img src="{{ skins_url }}/assets/images/logo.png" alt="logo">
								</span>
								<span class="logo-sm">
									<img src="{{ skins_url }}/assets/images/logo-sm.png" alt="small logo">
								</span>
							</a>
							<!-- Logo Dark -->
							<a href="{{ php_self }}" class="logo-dark">
								<span class="logo-lg">
									<img src="{{ skins_url }}/assets/images/logo-dark.png" alt="dark logo">
								</span>
								<span class="logo-sm">
									<img src="{{ skins_url }}/assets/images/logo-sm.png" alt="small logo">
								</span>
							</a>
						</div>
						<!-- Sidebar Menu Toggle Button -->
						<button class="button-toggle-menu">
							<i class="ri-menu-line"></i>
						</button>
						<!-- Horizontal Menu Toggle Button -->
						<button class="navbar-toggle" data-bs-toggle="collapse" data-bs-target="#topnav-menu-content">
							<div class="lines">
								<span></span>
								<span></span>
								<span></span>
							</div>
						</button>
					</div>
					<ul
						class="topbar-menu d-flex align-items-center gap-3">
						{# Кнопка: Очистить кэш (браузера + сервера) - показываем только при наличии прав #}
						{% if perm.cache %}
							<li class="d-none d-sm-inline-block">
								<a class="nav-link" href="#" id="btn-clear-cache" title="{{ lang['cache.clean']|default('Очистить кеш') }}">
									<i class="ri-refresh-line fs-22"></i>
								</a>
							</li>
						{% endif %}
						<li class="dropdown notification-list">
							<a class="nav-link dropdown-toggle arrow-none" href="{{ php_self }}?mod=pm" title="{{ lang['pm_t'] }} - {{ newpmText }}">
								<i class="ri-mail-line fs-22"></i>
								{% if newpm > 0 %}
									<span class="noti-icon-badge badge text-bg-purple">{{ newpm }}</span>
								{% endif %}
							</a>
						</li>
						<li class="dropdown notification-list">
							<a class="nav-link dropdown-toggle arrow-none" data-bs-toggle="dropdown" href="#" role="button" aria-haspopup="false" aria-expanded="false">
								<i class="ri-notification-3-line fs-22"></i>
								<span class="noti-icon-badge badge text-bg-pink">{{ unnAppLabel }}</span>
							</a>
							<div class="dropdown-menu dropdown-menu-end dropdown-menu-animated dropdown-lg py-0">
								<div class="p-2 border-top-0 border-start-0 border-end-0 border-dashed border">
									<div class="row align-items-center">
										<div class="col">
											<h6 class="m-0 fs-16 fw-semibold">{{ lang['notify.title'] }}</h6>
										</div>
										{# removed Clear button #}
									</div>
								</div>
								<div style="max-height: 300px;" data-simplebar>
									{{ unapproved1 }}
									{{ unapproved2 }}
									{{ unapproved3 }}
									{% if newpm > 0 %}
										<a class="dropdown-item" href="{{ php_self }}?mod=pm" title="{{ lang['pm_t'] }}">
											<div class="d-flex align-items-center">
												<div class="flex-shrink-0">
													<div class="notify-icon bg-primary">
														<i class="ri-mail-line"></i>
													</div>
												</div>
												<div class="flex-grow-1 ms-2">
													<h6 class="mt-0 mb-1 fs-13 fw-semibold">{{ newpmText }}</h6>
													<div class="fs-13 text-muted">
														<p class="mb-0">{{ lang['notify.new_pm'] }}</p>
													</div>
												</div>
											</div>
										</a>
									{% endif %}
								</div>
							</div>
						</li>
						<li class="d-none d-sm-inline-block">
							<a class="nav-link" data-bs-toggle="offcanvas" href="#theme-settings-offcanvas">
								<i class="ri-settings-3-line fs-22"></i>
							</a>
						</li>
						<li class="d-none d-sm-inline-block">
							<div class="nav-link" id="light-dark-mode">
								<i class="ri-moon-line fs-22"></i>
							</div>
						</li>
						<li class="dropdown">
							<a class="nav-link dropdown-toggle arrow-none nav-user" data-bs-toggle="dropdown" href="#" role="button" aria-haspopup="false" aria-expanded="false">
								<span class="account-user-avatar">
									<img src="{{ skin_UAvatar }}" alt="user-image" width="32" class="rounded-circle">
								</span>
								<span class="d-lg-block d-none">
									<h5 class="my-0 fw-normal">{{ user.name }}
										<i class="ri-arrow-down-s-line d-none d-sm-inline-block align-middle"></i>
									</h5>
								</span>
							</a>
							<div
								class="dropdown-menu dropdown-menu-end dropdown-menu-animated profile-dropdown">
								<!-- item-->
								<div class=" dropdown-header noti-title">
									<h6 class="text-overflow m-0">Добро пожаловать!</h6>
								</div>
								<!-- item-->
								<a href="?mod=users&action=editForm&id={{ user.id }}" title="{{ lang['loc_profile'] }}" class="dropdown-item">
									<i class="ri-account-circle-line fs-18 align-middle me-1"></i>
									<span>{{ lang['loc_profile'] }}</span>
								</a>
								<!-- item-->
								<a href="{{ php_self }}?action=logout" title="{{ lang['logout'] }}" class="dropdown-item">
									<i class="ri-logout-box-line fs-18 align-middle me-1"></i>
									<span>{{ lang['logout'] }}</span>
								</a>
							</div>
						</li>
					</ul>
				</div>
			</div>
			<!-- ========== Topbar End ========== -->
			<!-- ========== Left Sidebar Start ========== -->
			<div
				class="leftside-menu">
				<!-- Brand Logo Light -->
				<a href="{{ php_self }}" class="logo logo-light">
					<span class="logo-lg">
						<img src="{{ skins_url }}/assets/images/logo.png" alt="logo">
					</span>
					<span class="logo-sm">
						<img src="{{ skins_url }}/assets/images/logo-sm.png" alt="small logo">
					</span>
				</a>
				<!-- Brand Logo Dark -->
				<a href="{{ php_self }}" class="logo logo-dark">
					<span class="logo-lg">
						<img src="{{ skins_url }}/assets/images/logo-dark.png" alt="dark logo">
					</span>
					<span class="logo-sm">
						<img src="{{ skins_url }}/assets/images/logo-sm.png" alt="small logo">
					</span>
				</a>
				<!-- Sidebar -left -->
				<div
					class="h-100" id="leftside-menu-container" data-simplebar>
					<!--- Sidemenu -->
					<ul class="side-nav">
						<li class="side-nav-title">Основной</li>
						<li class="side-nav-item">
							<a href="{{ php_self }}" class="side-nav-link">
								<i class="ri-home-2-fill"></i>
								<span>
									{{ lang['admin_panel'] }}
								</span>
							</a>
						</li>
						<li class="side-nav-item">
							<a href="{{ home }}" target="_blank" class="side-nav-link">
								<i class="ri-function-fill"></i>
								<span>
									{{ lang['mainpage'] }}
								</span>
							</a>
						</li>
						{% if (perm.addnews) %}
							<li class="side-nav-item">
								<a href="{{ php_self }}?mod=news&action=add" class="side-nav-link">
									<i class="ri-newspaper-line"></i>
									<span>
										{{ lang['news.add'] }}
									</span>
								</a>
							</li>
						{% endif %}
						<li class="side-nav-item">
							<a data-bs-toggle="collapse" href="#news" aria-expanded="false" aria-controls="sidebarPages" class="side-nav-link">
								<i class="ri-pages-line"></i>
								<span>
									{{ lang['news_a'] }}
								</span>
								<span class="menu-arrow"></span>
							</a>
							<div class="collapse" id="news">
								<ul class="side-nav-second-level">
									{% if (perm.editnews) %}
										<li>
											<a href="{{ php_self }}?mod=news">{{ lang['news.edit'] }}</a>
										</li>
									{% endif %}
									{% if (perm.categories) %}
										<li>
											<a href="{{ php_self }}?mod=categories">{{ lang['news.categories'] }}</a>
										</li>
									{% endif %}
									{% if (perm.static) %}
										<li>
											<a href="{{ php_self }}?mod=static">{{ lang['static'] }}</a>
										</li>
									{% endif %}
									<li>
										<a href="{{ php_self }}?mod=images">{{ lang['images'] }}</a>
									</li>
									<li>
										<a href="{{ php_self }}?mod=files">{{ lang['files'] }}</a>
									</li>
									{% if comments_moderation_enabled and pluginIsActive('comments') %}
										<li>
											<a href="{{ php_self }}?plugin=comments&handler=moderation">Модерация комментариев</a>
										</li>
									{% endif %}
								</ul>
							</div>
						</li>
						<li class="side-nav-item">
							<a data-bs-toggle="collapse" href="#user" aria-expanded="false" aria-controls="sidebarPages" class="side-nav-link">
								<i class="ri-user-fill"></i>
								<span>
									{{ lang['userman'] }}
								</span>
								<span class="menu-arrow"></span>
							</a>
							<div class="collapse" id="user">
								<ul class="side-nav-second-level">
									{% if (perm.users) %}
										<li>
											<a href="{{ php_self }}?mod=users">{{ lang['users'] }}</a>
										</li>
									{% endif %}
									{% if (perm.ipban) %}
										<li>
											<a href="{{ php_self }}?mod=ipban">{{ lang['ipban_m'] }}</a>
										</li>
									{% endif %}
									<li>
										<a href="{{ php_self }}?mod=ugroup">{{ lang['ugroup'] }}</a>
									</li>
									<li>
										<a href="{{ php_self }}?mod=perm">{{ lang['uperm'] }}</a>
									</li>
								</ul>
							</div>
						</li>
						<li class="side-nav-item">
							<a data-bs-toggle="collapse" href="#system" aria-expanded="false" aria-controls="sidebarPages" class="side-nav-link">
								<i class="ri-settings-5-fill"></i>
								<span>
									{{ lang['system'] }}
								</span>
								<span class="menu-arrow"></span>
							</a>
							<div class="collapse" id="system">
								<ul class="side-nav-second-level">
									{% if (perm.configuration) %}
										<li>
											<a href="{{ php_self }}?mod=configuration">{{ lang['configuration'] }}</a>
										</li>
									{% endif %}
									{% if (perm.dbo) %}
										<li>
											<a href="{{ php_self }}?mod=dbo">{{ lang['options_database'] }}</a>
										</li>
									{% endif %}
									{% if (perm.rewrite) %}
										<li>
											<a href="{{ php_self }}?mod=rewrite">{{ lang['rewrite'] }}</a>
										</li>
									{% endif %}
									{% if (perm.cron) %}
										<li>
											<a href="{{ php_self }}?mod=cron">{{ lang['cron_m'] }}</a>
										</li>
									{% endif %}
								</ul>
							</div>
						</li>
						<li class="side-nav-item">
							<a href="{{ php_self }}?mod=extras" class="side-nav-link">
								<i class="ri-plug-fill"></i>
								<span>
									{{ lang['extras'] }}
								</span>
							</a>
						</li>
						{% if (perm.templates) %}
							<li class="side-nav-item">
								<a href="{{ php_self }}?mod=templates" class="side-nav-link">
									<i class="ri-edit-box-fill"></i>
									<span>
										{{ lang['templates_m'] }}
									</span>
								</a>
							</li>
						{% endif %}
						<li class="side-nav-title">Компоненты</li>
						<li class="side-nav-item">
							<a href="{{ php_self }}?mod=docs" class="side-nav-link">
								<i class="ri-book-line"></i>
								<span>
									Документация
								</span>
							</a>
						</li>
						<li class="side-nav-item">
							<a href="https://ngcms.ru/forum/" class="side-nav-link">
								<i class="ri-rocket-line"></i>
								<span>
									Форум поддержки
								</span>
							</a>
						</li>
						<li class="side-nav-item">
							<a href="https://ngcms.ru/" class="side-nav-link">
								<i class="ri-globe-line"></i>
								<span>
									Официальный сайт
								</span>
							</a>
						</li>
						<li class="side-nav-item">
							<a href="https://github.com/vponomarev/ngcms-core" class="side-nav-link">
								<i class="ri-github-line"></i>
								<span>
									Github
								</span>
							</a>
						</li>
					</ul>
					<!--- End Sidemenu -->
					<div class="clearfix"></div>
				</div>
			</div>
			<!-- ========== Left Sidebar End ========== -->
			<!-- ============================================================== -->
			<!-- Start Page Content here -->
			<!-- ============================================================== -->
				<div class="content-page"> <div
					class="content">
					<!-- Start Content-->
					<div class="container-fluid">
						{{ notify }}
						{{ main_admin }}
					</div>
					<!-- container -->
				</div>
				<!-- content -->
				<!-- Footer Start -->
				<footer class="footer">
					<div class="container-fluid">
						<div class="row">
							<div class="col-12 text-center">
								2008-{{ year }}
								©
								<a href="http://ngcms.ru" target="_blank">Next Generation CMS</a>
							</div>
						</div>
					</div>
				</footer>
				<!-- end Footer -->
			</div>
			<!-- ============================================================== -->
		<!-- End Page content -->
			<!-- ============================================================== -->
		</div>
		<!-- END wrapper -->
		<!-- Theme Settings -->
		<div class="offcanvas offcanvas-end" tabindex="-1" id="theme-settings-offcanvas">
			<div class="d-flex align-items-center bg-primary p-3 offcanvas-header">
				<h5 class="text-white m-0">Theme Settings</h5>
				<button type="button" class="btn-close btn-close-white ms-auto" data-bs-dismiss="offcanvas" aria-label="Close"></button>
			</div>
			<div class="offcanvas-body p-0">
				<div data-simplebar class="h-100">
					<div class="p-3">
						<h5 class="mb-3 fs-16 fw-bold">Color Scheme</h5>
						<div class="row">
							<div class="col-4">
								<div class="form-check form-switch card-switch mb-1">
									<input class="form-check-input" type="checkbox" name="data-bs-theme" id="layout-color-light" value="light">
									<label class="form-check-label" for="layout-color-light">
										<img src="{{ skins_url }}/assets/images/layouts/light.png" alt="" class="img-fluid">
									</label>
								</div>
								<h5 class="font-14 text-center text-muted mt-2">Light</h5>
							</div>
							<div class="col-4">
								<div class="form-check form-switch card-switch mb-1">
									<input class="form-check-input" type="checkbox" name="data-bs-theme" id="layout-color-dark" value="dark">
									<label class="form-check-label" for="layout-color-dark">
										<img src="{{ skins_url }}/assets/images/layouts/dark.png" alt="" class="img-fluid">
									</label>
								</div>
								<h5 class="font-14 text-center text-muted mt-2">Dark</h5>
							</div>
						</div>
						<div id="layout-width">
							<h5 class="my-3 fs-16 fw-bold">Layout Mode</h5>
							<div class="row">
								<div class="col-4">
									<div class="form-check form-switch card-switch mb-1">
										<input class="form-check-input" type="checkbox" name="data-layout-mode" id="layout-mode-fluid" value="fluid">
										<label class="form-check-label" for="layout-mode-fluid">
											<img src="{{ skins_url }}/assets/images/layouts/light.png" alt="" class="img-fluid">
										</label>
									</div>
									<h5 class="font-14 text-center text-muted mt-2">Fluid</h5>
								</div>
								<div class="col-4">
									<div id="layout-boxed">
										<div class="form-check form-switch card-switch mb-1">
											<input class="form-check-input" type="checkbox" name="data-layout-mode" id="layout-mode-boxed" value="boxed">
											<label class="form-check-label" for="layout-mode-boxed">
												<img src="{{ skins_url }}/assets/images/layouts/boxed.png" alt="" class="img-fluid">
											</label>
										</div>
										<h5 class="font-14 text-center text-muted mt-2">Boxed</h5>
									</div>
								</div>
							</div>
						</div>
						<h5 class="my-3 fs-16 fw-bold">Topbar Color</h5>
						<div class="row">
							<div class="col-4">
								<div class="form-check form-switch card-switch mb-1">
									<input class="form-check-input" type="checkbox" name="data-topbar-color" id="topbar-color-light" value="light">
									<label class="form-check-label" for="topbar-color-light">
										<img src="{{ skins_url }}/assets/images/layouts/light.png" alt="" class="img-fluid">
									</label>
								</div>
								<h5 class="font-14 text-center text-muted mt-2">Light</h5>
							</div>
							<div class="col-4">
								<div class="form-check form-switch card-switch mb-1">
									<input class="form-check-input" type="checkbox" name="data-topbar-color" id="topbar-color-dark" value="dark">
									<label class="form-check-label" for="topbar-color-dark">
										<img src="{{ skins_url }}/assets/images/layouts/topbar-dark.png" alt="" class="img-fluid">
									</label>
								</div>
								<h5 class="font-14 text-center text-muted mt-2">Dark</h5>
							</div>
						</div>
						<div>
							<h5 class="my-3 fs-16 fw-bold">Menu Color</h5>
							<div class="row">
								<div class="col-4">
									<div class="form-check form-switch card-switch mb-1">
										<input class="form-check-input" type="checkbox" name="data-menu-color" id="leftbar-color-light" value="light">
										<label class="form-check-label" for="leftbar-color-light">
											<img src="{{ skins_url }}/assets/images/layouts/sidebar-light.png" alt="" class="img-fluid">
										</label>
									</div>
									<h5 class="font-14 text-center text-muted mt-2">Light</h5>
								</div>
								<div class="col-4">
									<div class="form-check form-switch card-switch mb-1">
										<input class="form-check-input" type="checkbox" name="data-menu-color" id="leftbar-color-dark" value="dark">
										<label class="form-check-label" for="leftbar-color-dark">
											<img src="{{ skins_url }}/assets/images/layouts/light.png" alt="" class="img-fluid">
										</label>
									</div>
									<h5 class="font-14 text-center text-muted mt-2">Dark</h5>
								</div>
							</div>
						</div>
						<div id="sidebar-size">
							<h5 class="my-3 fs-16 fw-bold">Sidebar Size</h5>
							<div class="row">
								<div class="col-4">
									<div class="form-check form-switch card-switch mb-1">
										<input class="form-check-input" type="checkbox" name="data-sidenav-size" id="leftbar-size-default" value="default">
										<label class="form-check-label" for="leftbar-size-default">
											<img src="{{ skins_url }}/assets/images/layouts/light.png" alt="" class="img-fluid">
										</label>
									</div>
									<h5 class="font-14 text-center text-muted mt-2">Default</h5>
								</div>
								<div class="col-4">
									<div class="form-check form-switch card-switch mb-1">
										<input class="form-check-input" type="checkbox" name="data-sidenav-size" id="leftbar-size-compact" value="compact">
										<label class="form-check-label" for="leftbar-size-compact">
											<img src="{{ skins_url }}/assets/images/layouts/compact.png" alt="" class="img-fluid">
										</label>
									</div>
									<h5 class="font-14 text-center text-muted mt-2">Compact</h5>
								</div>
								<div class="col-4">
									<div class="form-check form-switch card-switch mb-1">
										<input class="form-check-input" type="checkbox" name="data-sidenav-size" id="leftbar-size-small" value="condensed">
										<label class="form-check-label" for="leftbar-size-small">
											<img src="{{ skins_url }}/assets/images/layouts/sm.png" alt="" class="img-fluid">
										</label>
									</div>
									<h5 class="font-14 text-center text-muted mt-2">Condensed</h5>
								</div>
								<div class="col-4">
									<div class="form-check form-switch card-switch mb-1">
										<input class="form-check-input" type="checkbox" name="data-sidenav-size" id="leftbar-size-full" value="full">
										<label class="form-check-label" for="leftbar-size-full">
											<img src="{{ skins_url }}/assets/images/layouts/full.png" alt="" class="img-fluid">
										</label>
									</div>
									<h5 class="font-14 text-center text-muted mt-2">Full Layout</h5>
								</div>
							</div>
						</div>
						<div id="layout-position">
							<h5 class="my-3 fs-16 fw-bold">Layout Position</h5>
							<div class="btn-group checkbox" role="group">
								<input type="radio" class="btn-check" name="data-layout-position" id="layout-position-fixed" value="fixed">
								<label class="btn btn-soft-primary w-sm" for="layout-position-fixed">Fixed</label>
								<input type="radio" class="btn-check" name="data-layout-position" id="layout-position-scrollable" value="scrollable">
								<label class="btn btn-soft-primary w-sm ms-0" for="layout-position-scrollable">Scrollable</label>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="offcanvas-footer border-top p-3 text-center">
				<div class="row">
					<div class="col-6">
						<button type="button" class="btn btn-light w-100" id="reset-layout">Reset</button>
					</div>
				</div>
			</div>
		</div>
		<script type="text/javascript">
			{% set encode_lang = lang | json_encode(constant('JSON_PRETTY_PRINT') b-or constant('JSON_UNESCAPED_UNICODE')) %}
window.NGCMS = {
admin_url: '{{ admin_url }}',
home: '{{ home }}',
lang: {{ encode_lang ?: '{}' }},
langcode: '{{ lang['langcode'] }}',
php_self: '{{ php_self }}',
skins_url: '{{ skins_url }}'
};
		</script>
		<script type="text/javascript">
			// Очистка кэшей браузера: localStorage, sessionStorage, Cache Storage
async function clearBrowserCaches() {
try { // local/session storage
try {
window.localStorage && window.localStorage.clear();
} catch (e) {}
try {
window.sessionStorage && window.sessionStorage.clear();
} catch (e) {}
// Cache Storage API
if (window.caches && caches.keys) {
const keys = await caches.keys();
await Promise.all(keys.map((k) => caches.delete(k)));
}
return true;
} catch (e) {
return false;
}
}
// Клик по иконке "Очистить кэш": чистим браузер и дергаем RPC admin.statistics.cleanCache
async function handleTopbarClearCacheClick(ev) {
ev && ev.preventDefault && ev.preventDefault();
// 1) Браузерный кэш
const browserOk = await clearBrowserCaches();
// 2) Серверный кэш (папка cache/) через RPC
try {
const resp = await post('admin.statistics.cleanCache', {
token: '{{ token_statistics|e('js') }}'
}, false);
if (resp && resp.status) {
ngNotifySticker('{{ lang['notify.cache.server_ok'] }}', {
className: 'alert-success',
closeBTN: true
});
} else {
ngNotifySticker('{{ lang['notify.cache.server_fail'] }}', {
className: 'alert-danger',
closeBTN: true
});
}
} catch (e) {
ngNotifySticker('{{ lang['notify.cache.server_fail'] }}', {
className: 'alert-danger',
closeBTN: true
});
}
// Итоговое уведомление по браузерному кэшу
if (browserOk) {
ngNotifySticker('{{ lang['notify.cache.browser_ok'] }}', {
className: 'alert-success',
closeBTN: true
});
} else {
ngNotifySticker('{{ lang['notify.cache.browser_fail'] }}', {
className: 'alert-warning',
closeBTN: true
});
}
return false;
}
document.addEventListener('DOMContentLoaded', function () {
const btn = document.getElementById('btn-clear-cache');
if (btn) {
btn.addEventListener('click', handleTopbarClearCacheClick);
}
});
		</script>
		<!-- moment.js до daterangepicker и datetimepicker -->
		<script src="{{ skins_url }}/assets/vendor/daterangepicker/moment.min.js"></script>
		<!-- daterangepicker -->
		<script src="{{ skins_url }}/assets/vendor/daterangepicker/daterangepicker.js"></script>
		<!-- datetimepicker (добавьте файл, если его нет) -->
		<script src="{{ skins_url }}/assets/vendor/datetimepicker/jquery.datetimepicker.full.min.js"></script>
		<!-- Apex Charts js -->
		<script src="{{ skins_url }}/assets/vendor/apexcharts/apexcharts.min.js"></script>
		<!-- Vector Map js -->
		<script src="{{ skins_url }}/assets/vendor/admin-resources/jquery.vectormap/jquery-jvectormap-1.2.2.min.js"></script>
		<script src="{{ skins_url }}/assets/vendor/admin-resources/jquery.vectormap/maps/jquery-jvectormap-world-mill-en.js"></script>
		<!-- Dashboard App js -->
		<script src="{{ skins_url }}/assets/js/pages/dashboard.js"></script>
		<!-- App js -->
		<script src="{{ skins_url }}/public/js/app.min.js"></script>
		<script type="module" src="{{ skins_url }}/public/js/bootstrap.js"></script>
	</body>
</html>
