<!DOCTYPE html>
<html lang="{{ lang['langcode'] }}">
	<head>
		<meta charset="{{ lang['encoding'] }}">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<title>{{ home_title }} - {{ lang['admin_panel'] }}</title>
		<!-- App favicon -->
		<link rel="shortcut icon" href="{{ skins_url }}/public/images/favicon.ico">
		<!-- Theme Config Js -->
		<script src="{{ skins_url }}/public/js/config.js"></script>
		<!-- App css -->
		<link href="{{ skins_url }}/public/css/app.min.css" rel="stylesheet" type="text/css" id="app-style" />
		<!-- Icons css -->
		<link href="{{ skins_url }}/public/css/icons.min.css" rel="stylesheet" type="text/css" />
		<script src="{{ skins_url }}/public/js/manifest.js"></script>
		<script src="{{ skins_url }}/public/js/vendor.js"></script>
		<script src="{{ skins_url }}/public/js/login.js"></script>
	</head>
	<body class="authentication-bg position-relative">
		<div class="account-pages pt-2 pt-sm-5 pb-4 pb-sm-5 position-relative">
			<div class="container">
				<div class="row justify-content-center">
					<div class="col-xxl-8 col-lg-10">
						<div class="card overflow-hidden">
							<div class="row g-0">
								<div class="col-lg-6 d-none d-lg-block p-2">
									<img src="{{ skins_url }}/assets/images/auth-img.jpg" alt="" class="img-fluid rounded h-100">
								</div>
								<div class="col-lg-6">
									<div class="d-flex flex-column h-100">
										<div class="auth-brand p-4">
											<a href="{{ php_self }}" class="logo-light">
												<img src="{{ skins_url }}/assets/images/logo.png" alt="logo" height="22">
											</a>
											<a href="{{ php_self }}" class="logo-dark">
												<img src="{{ skins_url }}/assets/images/logo-dark.png" alt="dark logo" height="22">
											</a>
										</div>
										<div class="p-4 my-auto">
											<h4 class="fs-20">{{ lang['admin_panel'] }}</h4>
											<p class="text-muted mb-3">Введите свой логин и пароль для доступа к учетной записи.</p>
											<!-- form -->
											<form name="login" method="post" action="{{ php_self }}">
												<input type="hidden" name="redirect" value="{{ redirect }}">
												<input type="hidden" name="action" value="login">
												<div class="mb-3">
													<label for="username" class="form-label">{{ lang['name'] }}</label>
													<input class="form-control" id="username" name="username" type="text" placeholder="Введите ваш логин">
												</div>
												<div class="mb-3">
													<label for="password" class="form-label">{{ lang['password'] }}</label>
													<input class="form-control" id="password" name="password" type="password" placeholder="Введите ваш пароль">
												</div>
												<div class="mb-0 text-start">
													<button class="btn btn-soft-primary w-100" type="submit"><i class="ri-login-circle-fill me-1"></i> <span class="fw-bold">{{ lang['login'] }}</span> </button>
												</div>
											</form>
											<!-- end form-->
										</div>
									</div>
								</div> <!-- end col -->
							</div>
						</div>
					</div>
					<!-- end row -->
				</div>
			</div>
			<!-- end container -->
		</div>
		<!-- end page -->
		<footer class="footer footer-alt fw-medium">
			<span class="text-dark">
				2008-{{ year }} © <a href="http://ngcms.ru" target="_blank">Next Generation CMS</a>
			</span>
		</footer>
		<!-- Vendor js -->
		<script src="{{ skins_url }}/assets/js/vendor.min.js"></script>
		<!-- App js -->
		<script src="{{ skins_url }}/assets/js/app.min.js"></script>
	</body>
</html>