<!-- start page title -->
<div class="row">
	<div class="col-12">
		<div class="page-title-box">
			<div class="page-title-right">
				<ol class="breadcrumb m-0">
					<li class="breadcrumb-item"><a href="{{ php_self }}"><i class="ri-home-2-fill"></i></a></li>
					<li class="breadcrumb-item active">{{ lang['permissions'] }}</li>
				</ol>
			</div>
			<h4 class="page-title">{{ lang['permissions'] }}</h4>
		</div>
	</div>
</div>
<!-- end page title -->
<style>
	.pChanged {
		border-color: var(--warning);
	}
</style>
<script type="text/javascript">
	var permDefault = {{ DEFAULT_JSON }};

	function onUpdatePerm(name) {
		var f = document.getElementById('permSubmit');
		var v = permDefault[name];

		f[name].classList.toggle('pChanged', f[name].value != v);
	}
</script>
<!-- Form header -->
<form id="permSubmit" name="permSubmit" method="post">
	<input type="hidden" name="token" value="{{ token }}" />
	<input type="hidden" name="save" value="1" />
	<!-- /Form header -->
	<div class="card mb-4">
		<div class="card-body">
			<!-- Group menu header -->
			<ul class="nav nav-pills mb-3 d-md-flex d-block" role="tablist">
				{% for group in GRP %}
					<li class="nav-item"><a href="#userTabs-{{ group.id }}" class="nav-link {{ loop.first ? 'active' : '' }}" data-toggle="tab">{{ group.title }}</a></li>
				{% endfor %}
			</ul>
			<!-- Group content header -->
			<div id="userTabs" class="tab-content">
				{% for group in GRP %}
					<!-- Content for group [{{ group.id }}] {{ group.title }} -->
					<div id="userTabs-{{ group.id }}" class="tab-pane {{ loop.first ? 'show active' : '' }}">
						<div class="alert alert-info">
							{{ lang['permissions_for_user_group'] }}: <b>{{ group.title }}</b>
						</div>
						{% for block in CONFIG %}
							<div class="pconf">
								<h3>{{ block.title }}</h3>
								{% if (block.description) %}<div class="alert alert-info">{{ block.description }}</div>{% endif %}
								{% for area in block.items %}
									<h4>{{ area.title }}</h4>
									{% if (area.description) %}<div class="alert alert-info">{{ area.description }}</div>{% endif %}
									<table class="table table-sm">
										<thead>
											<tr>
												<th>#ID</th>
												<th>{{ lang['description'] }}</th>
												<th>{{ lang['access'] }}</th>
											</tr>
										</thead>
										<tbody>
											{% for entry in area.items %}
												<tr>
													<td width="220"><b>{{ entry.id }}</b></td>
													<td>{{ entry.title }}</td>
													<td width="110">
														<select name="{{ entry.name }}|{{ group.id }}" onchange="onUpdatePerm('{{ entry.name }}|{{ group.id }}');" class="form-select custom-select-sm">
															<option value="-1">--</option>
															<option value="0" {{ isSet(entry.perm[group.id]) and (not entry.perm[group.id]) ? 'selected' : '' }}>{{ lang['noa'] }}</option>
															<option value="1" {{ isSet(entry.perm[group.id]) and (entry.perm[group.id]) ? 'selected' : '' }}>{{ lang['yesa'] }}</option>
														</select>
													</td>
												</tr>
											{% endfor %}
										</tbody>
									</table>
									<br />
								{% endfor %}
							</div>
						{% endfor %}
					</div>
					<!-- /Content for group [{{ group.id }}] {{ group.title }} -->
				{% endfor %}
			</div>
		</div>
	</div>
	<div class="form-group my-3 text-center">
		<button type="submit" class="btn btn-outline-success">{{ lang['save'] }}</button>
	</div>
</form>