<!-- start page title -->
<div class="row">
	<div class="col-12">
		<div class="page-title-box">
			<div class="page-title-right">
				<ol class="breadcrumb m-0">
					<li class="breadcrumb-item"><a href="admin.php"><i class="ri-home-2-fill"></i></a></li>
					<li class="breadcrumb-item active">{{ lang['user_groups'] }}</li>
				</ol>
			</div>
			<h4 class="page-title">{{ lang['user_groups'] }}</h4>
		</div>
	</div>
</div>
<!-- end page title -->
<div class="card">
	<div class="card-header">
		<div class="row">
			<div class="col text-right">
				{% if (flags.canAdd) %}
					<form method="get" action="">
						<input type="hidden" name="mod" value="ugroup" />
						<input type="hidden" name="action" value="addForm" />
						<button type="submit" class="btn btn-outline-success">{{ lang['add_group'] }}</button>
					</form>
				{% endif %}
			</div>
		</div>
	</div>
	<div class="table-responsive">
		<table class="table table-sm mb-0">
			<thead>
				<tr >
					<th>#</th>
					<th>{{ lang['identifier'] }}</th>
					<th>{{ lang['name'] }}</th>
					<th nowrap>{{ lang['users_in_group'] }}</th>
					<th>{{ lang['action'] }}</th>
				</tr>
			</thead>
			<tbody id="admCatList">
				{% for entry in entries %}
				<tr>
					<td>{{ entry.id }}</td>
					<td>{{ entry.identity }}</td>
					<td>{{ entry.name }}</td>
					<td>{{ entry.count }}</td>
					<td class="text-right">
						<div class="btn-group btn-group-sm" role="group">
							{% if (entry.flags.canEdit) %}
							<a href="{{ php_self }}?mod=ugroup&action=editForm&id={{ entry.id }}" class="btn btn-outline-primary"><i class="ri-pencil-line"></i></a>
							{% endif %}
							{% if (entry.flags.canDelete) %}
							<a href="{{ php_self }}?mod=ugroup&action=delete&id={{ entry.id }}&token={{ token }}" class="btn btn-outline-danger"><i class="ri-delete-bin-7-line"></i></a>
							{% endif %}
						</div>
					</td>
				</tr>
				{% endfor %}
			</tbody>
		</table>
	</div>
</div>