<!DOCTYPE html>
<!--[TWIG]-->
<html lang="{{ lang['encoding'] }}" class="no-js">
	<head>
		<meta http-equiv="content-type" content="text/html; charset={{ lang['encoding'] }}" />
		<meta http-equiv="content-language" content="{{ lang['langcode'] }}" />
		<meta name="generator" content="{{ what }} {{ version }}" />
		<meta name="document-state" content="dynamic" />
		<meta charset="utf-8">
		<meta name="HandheldFriendly" content="true">
		<meta name="format-detection" content="telephone=no">
		<meta name="viewport" content="user-scalable=0, initial-scale=1.0, maximum-scale=1.0, width=device-width"> 
		<meta name="apple-mobile-web-app-capable" content="yes">
		<meta name="apple-mobile-web-app-status-bar-style" content="default">
		{{ htmlvars }}
		<!-- CSS -->
		<link href="{{ tpl_url }}/css/engine.css" type="text/css" rel="stylesheet">
		<link href="{{ tpl_url }}/css/app.css" type="text/css" rel="stylesheet">
		<link href="{{ tpl_url }}/css/flexboxgrid.css" type="text/css" rel="stylesheet">
		<link href="{{ tpl_url }}/css/swiper.css" type="text/css" rel="stylesheet">
		<!-- Favicons -->
		<link rel="shortcut icon" href="{{ tpl_url }}/images/favicon.png">
		<link rel="apple-touch-icon" href="{{ tpl_url }}/images/touch-icon-iphone.png">
		<link rel="apple-touch-icon" sizes="76x76" href="{{ tpl_url }}/images/touch-icon-ipad.png">
		<link rel="apple-touch-icon" sizes="120x120" href="{{ tpl_url }}/images/touch-icon-iphone-retina.png">
		<link rel="apple-touch-icon" sizes="152x152" href="{{ tpl_url }}/images/touch-icon-ipad-retina.png">
		<!-- Fonts -->
		<link href="https://fonts.googleapis.com/css?family=PT+Sans:400,700&amp;subset=latin,cyrillic-ext" rel="stylesheet" type="text/css">
		<link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
		{% if pluginIsActive('rss_export') %}<link href="{{ home }}/rss.xml" rel="alternate" type="application/rss+xml" title="RSS" />{% endif %}
		<script type="text/javascript" src="{{ scriptLibrary }}/functions.js"></script>
		<script type="text/javascript" src="{{ scriptLibrary }}/ajax.js"></script>
		<title>{{ titles }}</title>
	</head>
	<body>
		{% block body %}
			<!-- wrap -->
			<div class="page__container container__fluid">
				<!-- columns -->
				<div class="columns flex">
					<!-- sidebar -->
					<aside class="sidebar col">
						<!-- sidebar__content -->
						<div class="sidebar__content">
							<a href="{{ home }}" class="logotype flex flex__middle" title="Главная страница">
								<img src="{{ tpl_url }}/images/logotype.png" alt="" />
							</a>
							<!-- sidebar__item -->
							<div class="sidebar__item">
								<span class="sidebar__title">
									<span class="aicon-Update">
				    	  				<span class="path1"></span>
					      				<span class="path2"></span>
				    				</span>
								 	Музыка
								</span>
								<!-- sidebar__menu -->
								<nav class="sidebar__menu">
									<!-- sidebar__menu-list -->
									<ul class="sidebar__menu-list">
										<li class="menu__item"><a href="{{ home }}" class="menu__link">Главная</a></li>
										<li class="menu__item"><a href="#" class="menu__link">Русская МУЗЫКА</a></li>
										<li class="menu__item"><a href="#" class="menu__link">Зарубежная МУЗЫКА</a></li>
										<li class="menu__item"><a href="#" class="menu__link">Клубная музыка</a></li>
										<li class="menu__item"><a href="#" class="menu__link">МУЗЫКА В МАШИНЕ</a></li>
										<li class="menu__item"><a href="#" class="menu__link">Новые РЕЛИЗЫ</a></li>
										<li class="menu__item"><a href="#" class="menu__link">МУЗЫКА</a></li>
										<li class="menu__item"><a href="#" class="menu__link">Альбом</a></li>
									</ul>
									<!-- /sidebar__menu-list -->
								</nav>
								<!-- /sidebar__menu -->
							</div>
							<!-- /sidebar__item -->
							<!-- sidebar__item -->
							<div class="sidebar__item">
								<span class="sidebar__title">
									<span class="aicon-Heart">
					      				<span class="path1"></span>
					      				<span class="path2"></span>
				    				</span>
									Избранное	    			
								</span>
								<ul class="sidebar__menu">
									<li class="menu__item">
										<a href="#" class="menu__link" title="title"> Любимые треки</a>
									</li>
								</ul>
							</div>
							<!-- /sidebar__item -->
							<!-- sidebar__item -->
							<div class="sidebar__item">
								<span class="sidebar__title">
									<span class="aicon-Option">
					      				<span class="path1"></span>
					      				<span class="path2"></span>
				    				</span>
									Жанры
								</span>
								<ul class="sidebar__menu" id="accordion">
									<li class="menu__item">
										<a href="javascript:void(0)" class="menu__link link" title="title"> 
											Выберите жанр
											<span class="aicon-Cursor">
							      				<span class="path1"></span>
							      				<span class="path2"></span>
						    				</span>	
										</a>
										<ul class="menu__submenu">
									        <li><a href="#">Rock</a></li>
									        <li><a href="#">Electronic</a></li>
									        <li><a href="#">Indie</a></li>
									        <li><a href="#">Pop</a></li>
									        <li><a href="#">Metal</a></li>
									        <li><a href="#">Jazz</a></li>
									        <li><a href="#">Folk</a></li>
									        <li><a href="#">Punk</a></li>
									        <li><a href="#">Hip-Hop</a></li>
									        <li><a href="#">Dance</a></li>
										</ul>
									</li>
								</ul>
							</div>
							<!-- /sidebar__item -->
							<!-- sidebar__item -->
							{% if not (global.flags.isLogged) %}
								<div class="sidebar__item">
									<span class="sidebar__title">
										<span class="aicon-Like">
											<span class="path1"></span>
											<span class="path2"></span>
										</span>
										Плейлист
									</span>
									<ul class="sidebar__menu">
										<li class="menu__item"><a href="#" class="menu__link">Favourites</a></li>
										<li class="menu__item"><a href="#" class="menu__link">50 Top Hits</a></li>
										<li class="menu__item"><a href="#" class="menu__link">Classic</a></li>
										<li class="menu__item"><a href="#" class="menu__link">80s</a></li>
									</ul>
								</div>
							{% endif %}
							<!-- /sidebar__item -->
							<!-- sidebar__item -->
							<div class="sidebar__item">
								{% if (global.flags.isLogged) %}
									<button class="button js__login">Профиль</button>
								{% else %}
									<button class="button js__login">Авторизоваться</button>
								{% endif %}
							</div>
							<!-- /sidebar__item -->
							<!-- sidebar__item -->
							<div class="sidebar__item" id="fixed">
								<div class="sidebar__advertising">
									<div class="advertising__title"><strong>PRO</strong></div>
									<div class="advertising__block"><strong>Музыка без ограничений с MIXIMus</strong></div>
									<div>Наслаждайтесь неограниченной музыкой на всех ваших устройствах всего за</div>
									<div class="advertising__price"><strong>200р /</strong> в месяц</div>
									<ul>
										<li>Без рекламы</li>
										<li>Высококачественный звук</li>
										<li>Устройства для прослушивания</li>
									</ul>
									<button class="button">СТАНЬ ПРОФИ</button>
								</div>
							</div>
							<!-- /sidebar__item -->
						</div>
						<!-- /sidebar__content -->
					</aside>
					<!-- /sidebar -->
					<!-- main -->
					<main class="main flex__row">
						<!-- header -->
						<header class="header flex ">
							<!-- header__content -->
							<div class="header__content flex flex__middle flex__between flex__around col">
								<div class="header__menu-button"><span class="fa fa-bars"></span></div>
								<a href="{{ home }}" class="logotype flex flex__middle" title="Главная страница">
									<img src="{{ tpl_url }}/images/logotype.png" alt="" />
								</a>
								<div class="search-box flex__row">
									{{ search_form }}
								</div>
							</div>
							<!-- /header__content -->
						</header>
						<!-- /header -->
						{% if isHandler('news:main') %}
							<!-- page__top-banner -->
							<aside class="page__top-banner">
								<!-- banner__content -->
								<div class="banner__content flex flex_column">
									<div class="information__statistic">В нашей базе уже <span>9750</span> песен!</div>
									<h1 class="heading h1"><strong>MIXIMus - музыка для жизни!</strong></h1>
									<div class="share__block flex flex__middle">
										<div class="share__block-title">Делиться</div>
										<!-- uSocial -->
										<script async src="https://usocial.pro/usocial/usocial.js?v=6.1.4" data-script="usocial" charset="utf-8"></script>
										<div class="uSocial-Share" data-pid="9cb699ede6dbb810f3a9877614eeb0b4" data-type="share" data-options="round,style4,default,absolute,horizontal,size48,counter0" data-social="vk,fb,twi,gPlus,telegram" data-mobile="vi,wa,sms"></div>
										<!-- /uSocial -->
									</div>
									<p class="caption">MIXIMus - это огромная музыкальная база данных, в которой вы найдете свою любимую музыку и сможете ее скачать.</p>
								</div>
								<!-- /banner__content -->
							</aside>
							<!-- /page__top-banner -->
							<!-- page__section -->
							<section class="page__section col clearfix">
								<div class="page__section-inner">
									<div class="page__section-title"><h2 class="heading h3">Жанры</h2></div>
									<div class="page__section-content genres__block">
										{{ categories }}
									</div>
								</div>
							</section>
							<!-- /page__section -->
							<!-- page__section -->
							<section class="page__section col clearfix">
								<div class="page__section-inner">
									<div class="page__section-title flex flex__middle flex__between">
										<h2 class="heading h3">Рекомендуемые альбомы</h2> 
										<button class="button"><a href="#">Просмотреть все</a></button>
									</div>
									<div class="page__section-content albums__block">
										{{ callPlugin('xnews.show', {'order' : 'last', 'count': '8', 'template' : 'shortstory__albums', 'cacheAge' : '60'}) }}
									</div>
								</div>
							</section>
							<!-- /page__section -->
							<!-- page__section -->
							<section class="page__section col clearfix">
								<div class="page__section-inner">
									<div class="page__section-title flex flex__middle flex__between">
										<h2 class="heading h3">Рекомендуемый артист</h2> 
										<button class="button"><a href="#">Просмотреть все</a></button>
									</div>
									<div class="artist__slider swiper-container">
										<div class="page__section-content artist__block swiper-wrapper">
											{{ callPlugin('xnews.show', {'order' : 'last', 'count': '20', 'template' : 'shortstory__artist', 'cacheAge' : '60'}) }}
										</div>
										<div class="swiper-button-prev">
											<span class="aicon-Back_2"><span class="path1"></span><span class="path2"></span></span>
										</div>
										<div class="swiper-button-next">
											<span class="aicon-Forward_2"><span class="path1"></span><span class="path2"></span></span>
										</div>
									</div>
								</div>
							</section>
							<!-- /page__section -->
							<!-- page__section -->
							<section class="page__section black col flex clearfix">
								<div class="page__section-inner col__md-6 col__sm-6 col__xs-12">
									<div class="page__section-title"><h2 class="heading h3">Лучшие треки</h2></div>
									<div class="page__section-content tracks__block">
										{{ callPlugin('xnews.show', {'order' : 'last', 'count': '10', 'template' : 'shortstory__tracks', 'cacheAge' : '60'}) }}
									</div>
								</div>
								<div class="page__section-inner col__md-6 col__sm-6 col__xs-12">
									<div class="page__section-title"><h2 class="heading h3">Hot Tracks</h2></div>
									<div class="page__section-content tracks__block">
										{{ callPlugin('xnews.show', {'order' : 'last', 'count': '10', 'template' : 'shortstory__tracks', 'cacheAge' : '60'}) }}
									</div>
								</div>
							</section>
							<!-- /page__section -->
							<!-- page__section -->
							<section class="page__section col clearfix">
								<div class="page__section-inner">
									<div class="page__section-content advc__block flex flex__center">
										<img src="{{ tpl_url }}/images/advc.jpg" alt="title" />
									</div>
								</div>
							</section>
							<!-- /page__section -->
							<!-- page__section -->
							<section class="page__section col clearfix">
								<div class="page__section-inner flex">
									<div class="col__md-4">
										<button class="page__section-button button">Добавить новые плейлисты</button>
										<div class="page__section-title"><h2 class="heading h3">Моя коллекция плейлистов</h2></div>
										<div class="page__section-playlists">10 плейлистов</div>
										<div class="page__section-playlists">Эти плейлисты часто загружаются, поэтому, если вам что-то понравилось, добавьте это в свою библиотеку.</div>
									</div>
									<div class="col__md-8 swiper-container">
										<div class="page__section-content playlists__block swiper-wrapper">
											{{ callPlugin('xnews.show', {'order' : 'last', 'count': '10', 'template' : 'shortstory__playlists', 'cacheAge' : '60'}) }}
										</div>
										<div class="swiper-button-prev">
											<span class="aicon-Back_2"><span class="path1"></span><span class="path2"></span></span>
										</div>
										<div class="swiper-button-next">
											<span class="aicon-Forward_2"><span class="path1"></span><span class="path2"></span></span>
										</div>
									</div>
								</div>
							</section>
							<!-- /page__section -->
						{% endif %}
						<!-- content -->
						<div class="content col clearfix">
							{% if isHandler('news:main') %}<div class="content__title"><h2 class="heading h3">Музыкальные релизы</h2></div>{% endif %}
							{% if pluginIsActive('breadcrumbs') %}{% if isHandler('news:news') %}{{ breadcrumbs }}{% endif %}{% endif %}
							{{ mainblock }}
						</div>
						<!-- /content -->
					</main>
					<!-- /main -->
				</div>
				<!-- /columns -->
			</div>
			<!-- /wrap -->
			{{ personal_menu }}
			<!-- JS -->
			<script type="text/javascript" src="{{ tpl_url }}/js/jquery.js"></script>
			<script type="text/javascript" src="{{ tpl_url }}/js/jqueryui.js"></script>
			<script src="{{ tpl_url }}/js/app.js"></script>
			<div id="loading-layer" style="display:none">{{ lang.theme.main_loading }}</div>
		{% endblock %}
	</body>
</html>
<!--[/TWIG]-->