<form name="form" method="POST" action="{{ php_self }}?action=delete" style="display: inline;">
<article class="box__story">
	<h1 class="heading__other h3">{{ lang['pm:pm'] }}</h1>
	<div class="pm-box">
		<nav id="pm-menu">
			<a href="{{ pm_inbox_link }}"><span>{{ lang['pm:inbox'] }}</span></a>
			<a href="{{ pm_outbox_link }}"><span>{{ lang['pm:outbox'] }}</span></a>
			<a href="{{ pm_set_link }}"><span>{{ lang['pm:set'] }}</span></a>
		</nav>
		{% if max_messages > 0 %}
			<div class="pm_status">
				<div class="pm_progress_bar" title="{{ lang.theme.pm_current_messages }}: {{ current_messages }}%"><span style="width: {{ current_messages }}%">{{ current_messages }}%</span></div>
				<div class="grey">{{ current_messages }}% / ({{ max_messages }} {{ lang.theme.pm_max_messages }})</div>
			</div>
		{% endif %}
	</div>
	<table width="100%" class="pm">
		<tr align="center">
			<td width="20%" class="pm_head">{{ lang['pm:date'] }}</td>
			<td width="40%" class="pm_head">{{ lang['pm:subject'] }}</td>
			<td width="25%" class="pm_head">{{ lang['pm:from'] }}</td>
			<td width="10%" class="pm_head">{{ lang['pm:state'] }}</td>
			<td width="5%" class="pm_head"><input type="checkbox" name="master_box" title="{{ lang['pm:checkall'] }}" onclick="javascript:check_uncheck_all(form)"></td>
		</tr>
		{% for entry in entries %}
			<tr align="center">
				<td class="pm_list">{{ entry.pmdate|date('Y-m-d H:i') }}</td>
				<td class="pm_list"><a href="{{ php_self }}?action=read&pmid={{ entry.pmid }}&location=inbox">{{ entry.subject }}</a></td>
				<td class="pm_list">{{ entry.link }}</td>
				<td class="pm_list">{% if (entry.viewed == 1) %}<img src="/engine/plugins/pm/img/viewed.yes.gif" />{% else %}<img src="/engine/plugins/pm/img/viewed.no.gif" />{% endif %}</td>
				<td class="pm_list"><input name="selected_pm[]" value="{{ entry.pmid }}" type="checkbox"/></td>
			</tr>
		{% endfor %}
	</table>
	{% if pagination %}
		<div class="pagination ignore-select flex flex__center" style="margin-bottom: 10px;">
			<div class="pages">{{ pagination }}</div>
		</div>
	{% endif %}
	<div class="form_submit" style="margin-top: 10px;">
		<button class="btn" type="submit">{{ lang['pm:delete'] }}</button></form>
		<form name="pm" method="POST" action="{{ php_self }}?action=write" style="display: inline;">
			<button class="btn" type="submit">{{ lang['pm:write'] }}</button>
		</form>
	</div>
</article>