<!--noindex-->
{% if (global.flags.isLogged) %}
	<div class="login__box" id="login__box" title="{{ global.user.name }}">
		<div class="login__box-user flex flex__middle ">
			<div class="login__box-avatar"><img src="{{ avatar_url }}" title="{{ global.user.name }}" alt="{{ global.user.name }}" /></div>
			<div class="login__box-name">
				<div>{{ global.user.name }}</div>
				{% if (global.flags.isLogged and (global.user['status'] <= 3)) %}<a href="{{ admin_url }}" target="_blank">{{ lang.admin_panel }}</a>{% endif %}
			</div>
		</div>
		<ul class="login__box-menu">
			{% if pluginIsActive('nsm') %}
				<li><a href="{{ p.nsm.link }}">{{ lang.add_news }}</a></li>
			{% endif %}
			{% if pluginIsActive('pm') %}
				<li><a href="{{ p.pm.link }}">{{ lang.private_messages }} ( {{ p.pm.pm_unread }} / {{ p.pm.pm_all }} )</a></li>
			{% endif %}
			{% if pluginIsActive('bookmarks') %}
				<li><a href="{{ p.bookmarks.link }}">{{ lang.theme.p_bookmarks }} ( {{ p.bookmarks.count }} )</a></li>
			{% endif %}
			{% if pluginIsActive('uprofile') %}
				<li><a href="{{ user_link }}" >{{ lang.myprofile }}</a></li>
				<li><a href="{{ profile_link }}">{{ lang.edit_profile }}</a></li>
			{% endif %}
			<li><a href="{{ logout_link }}">{{ lang.log_out }}</a></li>
		</ul>
	</div>
{% else %}
	<script language="javascript">
		var set_login = 0;
		var set_pass  = 0;
	</script>
	<div class="login__box" id="login__box" title="Авторизация">
		<form name="login" method="post" action="{{ form_action }}" id="login">
			<input type="text" name="username" placeholder="{{ lang.username }}"/>
			<input type="password" name="password" placeholder="{{ lang.password }}" />
			<button type="submit" title="{{ lang.login }}" class="button">{{ lang.login }}</button>
			<input type="hidden" name="redirect" value="{{ redirect }}" />
			<div class="login__box-check">
				<input type="checkbox" name="login_not_save" id="login_not_save" value="1"/>
				<label for="login_not_save">{{ lang.remember_me }}</label> 
			</div>
			<div class="login__box-link flex flex__between">
				<a href="{{ lost_link }}">{{ lang.lostpassword }}</a>
				<a href="{{ reg_link }}" class="log-register">{{ lang.registration }}</a>
			</div>
		</form>
	<div class="login__box-social">
		<div>Войти с помощью:</div>
		<a href="#"><img src="{{ tpl_url }}/images/social/vk.png" /></a>
		<a href="#"><img src="{{ tpl_url }}/images/social/ok.png" /></a>
		<a href="#"><img src="{{ tpl_url }}/images/social/fb.png" /></a>
		<a href="#"><img src="{{ tpl_url }}/images/social/mail.png" /></a>
		<a href="#"><img src="{{ tpl_url }}/images/social/google.png" /></a>
		<a href="#"><img src="{{ tpl_url }}/images/social/yandex.png" /></a>
	</div>
	</div>
{% endif %}
<!--/noindex-->