{% if isHandler('news:main') %}
	<div class="page-head-main">
		<h1 class="title">Игры и программы для Android</h1>
		<img width="1408" height="276" src="{{ tpl_url }}/images/main_illustration.svg" alt="">
	</div>
	<section class="wrp section section-recom">
		<h3 class="section-title">
			<i class="s-green c-icon">
				<svg width="24" height="24">
					<use xlink:href="#i__hot"></use>
				</svg>
			</i>
			Рекомендуем
		</h3>
		<div class="scroll-entry-list">
			<div class="entry-list recom-list list-c4">
				{{ callPlugin('xnews.show', {'extractEmbeddedItems' : true, 'order' : 'last', 'count': '4', 'template' : 'custom-rek', 'cacheAge' : '180'}) }}
			</div>
		</div>
	</section>
	<section class="wrp section">
		<div class="section-head">
			<h3 class="section-title">
				<i class="s-yellow c-icon">
					<svg width="24" height="24">
						<use xlink:href="#i__gamepad"></use>
					</svg>
				</i>
				Новые игры
			</h3>
			<a class="btn s-green btn-all" href="#">
				<span>Все игры</span>
				<svg width="24" height="24">
					<use xlink:href="#i__keyright"></use>
				</svg>
			</a>
		</div>
		<div class="entry-list list-c6">
			{{ callPlugin('xnews.show', {'extractEmbeddedItems' : true, 'order' : 'last', 'count': '12', 'template' : 'news-short', 'cacheAge' : '180'}) }}
		</div>
	</section>
	<section class="wrp section">
		<div class="section-head">
			<h3 class="section-title">
				<i class="s-purple c-icon">
					<svg width="24" height="24">
						<use xlink:href="#i__apps"></use>
					</svg>
				</i>
				Новые программы
			</h3>
			<a class="btn s-green btn-all" href="#">
				<span>Все программы</span>
				<svg width="24" height="24">
					<use xlink:href="#i__keyright"></use>
				</svg>
			</a>
		</div>
		<div class="entry-list list-c6">
			{{ callPlugin('xnews.show', {'extractEmbeddedItems' : true, 'order' : 'last', 'count': '12', 'template' : 'news-short', 'cacheAge' : '180'}) }}
		</div>
	</section>
	<div class="dark-foot dark-section">
		<section class="wrp section section-news">
			<div class="section-head">
				<h3 class="section-title">
					<i class="s-blue c-icon">
						<svg width="24" height="24">
							<use xlink:href="#i__flash"></use>
						</svg>
					</i>
					Последние новости
				</h3>
				<a class="btn s-green btn-all" href="#">
					<span>Все новости</span>
					<svg width="24" height="24">
						<use xlink:href="#i__keyright"></use>
					</svg>
				</a>
			</div>
			<div class="entry-list list-c2">
				{{ callPlugin('xnews.show', {'extractEmbeddedItems' : true, 'order' : 'last', 'count': '2', 'template' : 'custom-news', 'cacheAge' : '180'}) }}
			</div>
		</section>
		{% if pluginIsActive('lastcomments') %}
			{{ plugin_lastcomments }}
		{% endif %}
	</div>
{% endif %}
{% if isHandler('bookmarks') %}
	<div class="page-head-cat">
		<div class="wrp-min">
			<div class="head-cat-title">
				<h1 class="title">В закладках</h1>
			</div>
		</div>
		<i class="bg-clouds"></i>
	</div>
{% endif %}
{% if isHandler('nsm') %}
	<div class="page-sys">
		<section class="section">
			<div class="wrp-min block-list">
				<div class="block static-page">
					<div class="b-cont">
						<div id='dle-content'>{{ mainblock }}</div>
					</div>
				</div>
			</div>
		</section>
	</div>
{% endif %}
{% if isHandler('search') %}
	<div class="page-head-cat darkmod">
		<div class="wrp-min">
			<div class="head-cat-title">
				<h1 class="title">Поиск по сайту</h1>
			</div>
		</div>
		<i class="bg-clouds"></i>
	</div>
	<div class="page-cat-bg page-search-bg">
		<div class="wrp page-cat-cont">
		<div class="entry-listpage list-c6">
			<div id='dle-content'>{{ mainblock }}</div>
		</div>
	</div>
{% endif %}
{% if isHandler('news:news|comments') %}
	{{ mainblock }}
{% endif %}
{% if isHandler('lastcomments') %}
	<div id='dle-content'>{{ mainblock }}</div>
{% endif %}
{% if not isHandler('news:news|comments|news:main|news:by.category|pm|nsm|feedback|lastcomments|search|uprofile|core:login|core:registration|core:lostpassword') %}
	<div class="page-cat-bg">
		<div class="wrp page-cat-cont">
			<div class="entry-listpage list-c6">
				<div id='dle-content'>{{ mainblock }}</div>
			</div>
		</div>
	</div>
{% endif %}
{% if isHandler('uprofile') %}
	<div class="page-sys page-user">
		<section class="section">
			<div id='dle-content'>{{ mainblock }}</div>
		</section>
	</div>
{% endif %}