<!DOCTYPE html>
<!--[TWIG]-->
<html lang="{{ lang['langcode'] }}" lang="ru" id="h" class="load">
	<head>
		<meta http-equiv="content-type" content="text/html;" charset="{{ lang['encoding'] }}" />
		<meta http-equiv="content-language" content="{{ lang['langcode'] }}" />
		<meta name="generator" content="{{ what }} {{ version }}" />
		<meta name="document-state" content="dynamic" />
		<meta name="viewport" content="initial-scale=1.0, maximum-scale=5.0, width=device-width">
		<meta property="og:image" content="{{ tpl_url }}/images/favicon/logo.png">
		{{ htmlvars }}
		<link rel="icon" href="{{ tpl_url }}/images/favicon/f16.png" sizes="16x16" type="image/png">
		<link rel="icon" href="{{ tpl_url }}/images/favicon/f32.png" sizes="32x32" type="image/png">
		<link rel="icon" href="{{ tpl_url }}/images/favicon/f96.png" sizes="96x96" type="image/png">
		<link rel="apple-touch-icon" sizes="180x180" href="{{ tpl_url }}/images/favicon/apple-touch-icon.png">
		{% if isHandler('nsm|lastcomments|search|uprofile') %}
			<link href="{{ tpl_url }}/css/other.css" type="text/css" rel="stylesheet">
		{% endif %}
		{% if isHandler('pm|feedback|core:login|core:registration|core:lostpassword') %}
			<link href="{{ tpl_url }}/css/form.css" type="text/css" rel="stylesheet">
		{% endif %}
		{% if not isHandler('pm|feedback|lastcomments') %}
			<link href="{{ tpl_url }}/css/styles.css" type="text/css" rel="stylesheet">
			<link href="{{ tpl_url }}/css/short.css" type="text/css" rel="stylesheet">
		{% endif %}
		{% if isHandler('news:news|comments') %}
			<link href="{{ tpl_url }}/css/comments.css" type="text/css" rel="stylesheet">
			<link href="{{ tpl_url }}/css/fullstory.css" type="text/css" rel="stylesheet">
			<link href="{{ tpl_url }}/css/jquery.fancybox.min.css" type="text/css" rel="stylesheet">
		{% endif %}
		{% if isHandler('lastcomments') %}
			<link href="{{ tpl_url }}/css/comments.css" type="text/css" rel="stylesheet">
			<link href="{{ tpl_url }}/css/styles.css" type="text/css" rel="stylesheet">
		{% endif %}
		{% if isHandler('uprofile') %}
			<link href="{{ tpl_url }}/css/user.css" type="text/css" rel="stylesheet">
		{% endif %}
		<link href="{{ tpl_url }}/css/core.css" type="text/css" rel="stylesheet">
		<link href="{{ tpl_url }}/css/user.css" type="text/css" rel="stylesheet">
		{% if pluginIsActive('rss_export') %}<link href="{{ home }}/rss.xml" rel="alternate" type="application/rss+xml" title="RSS" />{% endif %}
		<script type="text/javascript" src="{{ scriptLibrary }}/functions.js"></script>
		<script type="text/javascript" src="{{ scriptLibrary }}/ajax.js"></script>
		<title>{{ titles }}</title>
	</head>
	<body>
		{% block body %}
			{% if not isHandler('pm|feedback|core:login|core:registration|core:lostpassword') %}
				<header class="header">
					<div class="wrp-min">
						<div class="header-panel">
							<a class="logotype" href="{{ home }}" title="5play">
								<span class="sr-only">5play</span>
								<svg width="104" height="36"><use xlink:href="#logo-5play"></use></svg>
							</a>
							<div id="mobilemenu" class="head-tools" style="display: none;">
								<div class="head-tools-panel">
									<nav class="hmenu" itemscope="" itemtype="http://schema.org/SiteNavigationElement">
										<a class="hm-games" itemprop="url" href="#">
											<span itemprop="name">
												<i class="s-yellow c-icon">
													<svg width="24" height="24">
														<use xlink:href="#i__gamepad"></use>
													</svg>
												</i>
												Игры
											</span>
										</a>
										<a class="hm-apps" itemprop="url" href="#">
											<span itemprop="name">
												<i class="s-purple c-icon">
													<svg width="24" height="24">
														<use xlink:href="#i__apps"></use>
													</svg>
												</i>
												Программы
											</span>
										</a>
										<a class="hm-top" itemprop="url" href="#">
											<span itemprop="name">
												<i class="s-red c-icon">
													<svg width="24" height="24">
														<use xlink:href="#i__cup"></use>
													</svg>
												</i>
												Топ 100
											</span>
										</a>
										<a class="hm-news" itemprop="url" href="#">
											<span itemprop="name">
												<i class="s-blue c-icon">
													<svg width="24" height="24">
														<use xlink:href="#i__flash"></use>
													</svg>
												</i>
												Новости
											</span>
										</a>
										<div class="hmenu-more dropdown">
											<button class="hmenu-more-btn"><span class="hmenu-more-dots"><i></i><i></i><i></i></span></button>
											<div style="display: none;" class="dropdown-menu">
												<div class="hmenu-order">
													<a href="#" rel="nofollow">Стол заказов</a>
													<svg width="32" height="32">
														<use xlink:href="#i__order"></use>
													</svg>
												</div>
												<nav class="hmenu-sub">
													<a href="#">Обратная связь</a>
													<a href="#">Условия использования информации</a>
													<a href="#">Отказ от ответственности</a>
													<a href="#">Правообладателям</a>
												</nav>
											</div>
										</div>
									</nav>
									{{ search_form }}
									<button class="menu-toggle menu-close bbcodes" aria-label="Menu Close" style="display: none;">
										<svg width="24" height="24">
											<use xlink:href="#i__close"></use>
										</svg>
									</button>
								</div>
								<div class="menu-toggle mm-overlay" style="display: none;"></div>
							</div>
							<div class="head-right">
								{% if (global.flags.isLogged) %}
									{{ personal_menu }}
								{% else %}
									<button data-toggle="modal" data-target="#login" class="log-in">
										<span class="sr-only">Авторизация</span>
										<svg width="24" height="24">
											<use xlink:href="#i__user"></use>
										</svg>
									</button>
								{% endif %}
								<button style="display: none;" class="q-search-call" aria-label="Найти">
									<span class="sr-only">Найти</span>
									<svg class="qs-1" width="24" height="24">
										<use xlink:href="#i__search"></use>
									</svg>
									<svg class="qs-2" width="24" height="24">
										<use xlink:href="#i__close"></use>
									</svg>
								</button>
							</div>
							<button class="menu-toggle menu-butter" aria-label="Mobile Menu" style="display: none;"><span class="butterbrod"><i></i><i></i><i></i></span></button>
						</div>
					</div>
				</header>
			{% endif %}
			<div class="toolbar">
				<button class="sel-dark-toggle" id="toggle-darkmod">
					<svg class="i__moon" width="24" height="24">
						<use xlink:href="#i__moon"></use>
					</svg>
					<svg class="i__sun" width="24" height="24" style="display:none;">
						<use xlink:href="#i__sun"></use>
					</svg>
				</button>
			</div>
			<script>
				const
				g=i=>document.getElementById(i),
				classes=g('h').classList,
				cl="darktheme";

				if(localStorage.getItem("toggled-ttl")>Date.now())
				classes.toggle(cl,localStorage.getItem("toggled"));

				g("toggle-darkmod").addEventListener("click",function(e){
					e.preventDefault();

					if(classes.contains(cl)) {
						localStorage.removeItem("toggled");
						localStorage.removeItem("toggled-ttl");
						classes.remove(cl);
					}
					else {
						localStorage.setItem("toggled",1);
						localStorage.setItem("toggled-ttl",Date.now() + 60*86400000);
						classes.add(cl);
					}
				});
			</script>
			{% if isHandler('pm|feedback|core:login|core:registration|core:lostpassword') %}
				<section class="page-form">
					<header class="page-form-left">
						<div class="page-form-head">
							<a class="logotype" href="{{ home }}" title="5play">
								<span class="sr-only">5play</span>
								<svg width="104" height="36">
									<use xlink:href="#logo-5play"></use>
								</svg>
							</a>
							<h1 class="title">Игры и программы для Android</h1>
						</div>
						<i class="page-form-bg"></i>
					</header>
					<div class="page-form-right">
						<div class="page-form-right-in">
							<div class="pag-form_head">
								<a class="back_to_main" href="{{ home }}">
									<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" height="24" width="24">
										<path fill="currentColor" d="M20 11H6.83l2.88-2.88c.39-.39.39-1.02 0-1.41-.39-.39-1.02-.39-1.41 0L3.71 11.3c-.39.39-.39 1.02 0 1.41L8.3 17.3c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41L6.83 13H20c.55 0 1-.45 1-1s-.45-1-1-1z" />
									</svg>
									Вернуться на главную
								</a>
							</div>
							<main class="page-form-cont">
								<div class="wrp-form-mid">
									<div id='dle-content'>{{ mainblock }}</div>
								</div>
							</main>
							<div class="page-form_foot c-muted">
								<div class="copyright">
									2021 © 5play.ru - Приложения на андроид - игры, программы, обои, виджеты
								</div>
							</div>
						</div>
					</div>
				</section>
			{% endif %}
			{% include "includes/category.tpl" %}
			{% include "includes/mainpage.tpl" %}
			{% if not isHandler('pm|feedback|core:login|core:registration|core:lostpassword') %}
				<footer class="footer">
					<div class="wrp-min">
						<div class="footer-panel">
							<a class="logotype scrollup" style="display:none;" href="{{ home }}" title="5play">
								<span class="sr-only">5play</span>
								<i class="logo-icon">
									<svg width="104" height="36">
										<use xlink:href="#logo-5play"></use>
									</svg>
								</i>
							</a>
							<a class="upper scrollup" href="{{ home }}" title="Наверх">
								<span class="sr-only">Наверх</span>
								<svg width="24" height="24">
									<use xlink:href="#i__scrollup"></use>
								</svg>
							</a>
							<div class="footer-cont">
								<div class="copyright">2021 © 5play.ru - игры и программы для андроид</div>
								<div class="f-telegram">
									<a href="#" target="_blank" rel="nofollow noopener">
										<i class="c-icon s-telegram">
											<svg width="24" height="24">
												<use xlink:href="#i__telegram"></use>
											</svg>
										</i>
										<span>Наш Telegram</span>
									</a>
								</div>
							</div>
						</div>
					</div>
				</footer>
			{% endif %}
			{% if not (global.flags.isLogged) %}
				<div class="background" style="display:none;">
					<i class="bg-circle-green"></i>
					<i class="bg-clouds">
						<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 2550 700" width="2550" height="700">
							<path fill="#142636" d="M554,600h-4a50,50,0,0,0,0,100h4a50,50,0,0,0,0-100ZM802,0H50a50,50,0,0,0,0,100h78.08a50,50,0,0,1,.11,100H98a50,50,0,0,0,0,100H238a50,50,0,1,1,0,100H194a50,50,0,0,0,0,100h56a50,50,0,0,1,.3,100H238a50,50,0,0,0,0,100H430a50,50,0,0,0,0-100H413.55a50,50,0,0,1,.05-100H630a50,50,0,0,0,0-100H521.55a50,50,0,0,1,0-100H526a50,50,0,0,0,0-100H445.55a50,50,0,0,1,.08-100H802A50,50,0,0,0,802,0Z" />
							<path fill="#142636" d="M2073,500a50,50,0,0,1,0-100h16.43a50,50,0,0,0,0-100H1901a50,50,0,0,1,0-100h216.42a49.92,49.92,0,0,0,34.94-14.64,50,50,0,0,0-34.9-85.36H2097a50,50,0,0,1-50-50h0a50,50,0,0,1,50-50h252a50,50,0,0,1,0,100h-28a50,50,0,1,0,0,100h24a50,50,0,0,1,0,100h-24a50,50,0,1,0,0,100h179a50,50,0,0,1,0,100Z" />
						</svg>
					</i>
				</div>
			</div>
			<div class="modal fade login_modal" id="login" tabindex="-1" role="dialog" aria-labelledby="login_dialog" aria-hidden="true">
				<div class="modal-dialog modal-dialog-centered" role="document">
					<div class="modal-content">{{ personal_menu }}</div>
				</div>
			</div>
			{% endif %}
			{% include "includes/bg.tpl" %}
			<script type="text/javascript" src="{{ tpl_url }}/js/jquery.js"></script>
			<script type="text/javascript" src="{{ tpl_url }}/js/jqueryui.js"></script>
			<div id="loading-layer" style="display:none">
				<div class="loading-layer">{{ lang.theme.loading }}</div>
			</div>
			<script src="{{ tpl_url }}/js/bootstrap.min.js"></script>
			{% if isHandler('news:news') %}
				<script src="{{ tpl_url }}/js/jquery.fancybox.min.js"></script>
				<script src="{{ tpl_url }}/js/loadvideo.js"></script>
				<script>
					$(document).ready(function() { $('html').removeClass('load'); });
					$(function() {
						$('.dropdown-form').click(function(e) {
							e.stopPropagation();
						});
						
						$('.q-search-call').on('click', function(){
							$('.q-search').toggleClass('open');
							setTimeout(function() { $('.header').toggleClass('qs'); }, 50);
							return false;
						});
						
						$('.scrollup').click(function(){ $('html, body').animate({scrollTop:0}, 'fast'); return false; });
						
						var $root = $('html, body');
						$('a.anchor').click(function() {
							var href = $.attr(this, 'href');
							$root.animate({
								scrollTop: $(href).offset().top
							}, 500);
							return false;
						});
						
						$('.menu-toggle').on('click', function(){
							$('#mobilemenu').toggleClass('open');
							setTimeout(function() { $('html').toggleClass('mm'); }, 50);
							return false;
						});
						
					});
					
					$(function(){
						var tabContainers = $('.tab-content .tab-pane');
						tabContainers.hide().filter(':first').show();
						
						$('.tab-item').click(function () {
							tabContainers.hide();
							tabContainers.filter(this.hash).show();
							$('.tab-item').removeClass('active');
							$(this).addClass('active');
							return false;
						}).filter(':first').click();
					});
				</script>
			{% else %}
				<script>
					$(document).ready(function() { $('html').removeClass('load'); });
					$(function() {
						$('.dropdown-form').click(function(e) {
							e.stopPropagation();
						});
						
						$('.social-links a').on('click',function(){
							var href = $(this).attr('href');
							var width  = 820;
							var height = 420;
							var left   = (screen.width  - width)/2;
							var top   = (screen.height - height)/2-100;
							
							auth_window = window.open(href, 'auth_window', "width="+width+",height="+height+",top="+top+",left="+left+"menubar=no,resizable=no,scrollbars=no,status=no,toolbar=no");
							return false;
						});
						
						$('.q-search-call').on('click', function(){
							$('.q-search').toggleClass('open');
							setTimeout(function() { $('.header').toggleClass('qs'); }, 50);
							return false;
						});
						
						$('.scrollup').click(function(){ $('html, body').animate({scrollTop:0}, 'fast'); return false; });
						
						var $root = $('html, body');
						$('a.anchor').click(function() {
							var href = $.attr(this, 'href');
							$root.animate({
								scrollTop: $(href).offset().top
							}, 500);
							return false;
						});
						
						$('.menu-toggle').on('click', function(){
							$('#mobilemenu').toggleClass('open');
							setTimeout(function() { $('html').toggleClass('mm'); }, 50);
							return false;
						});
					});
				</script>
			{% endif %}
		{% endblock %}
	</body>
</html>
<!--[/TWIG]-->