[TWIG]
{% if not isNews('cat:1') %}
<article class="view-app" itemscope="" itemtype="http://schema.org/MobileApplication">
	<div class="view-app-head dark-head dark-section">
		<div class="wrp-min">
			<h1 itemprop="name" class="title">{{ news.title }}</h1>
			<div class="view-app-main ignore-select">
				<div class="view-app-img">
					<figure class="img">
						<img src="{% if (news.embed.imgCount > 0) %}{{ news.embed.images[0] }}{% else %}{{ tpl_url }}/images/no_image.png{% endif %}" alt="{{ news.title }}" width="240" height="240">
					</figure>
					{% if pluginIsActive('bookmarks') %}
						{% if (global.flags.isLogged) %}
							<div class="view-app-tools c-yellow">
								{{ plugin_bookmarks_news }}
							</div>
						{% endif %}
					{% endif %}
				</div>
				<div class="view-app-data">
					<div class="specs-list">
						<ul>
							<li class="specs-item">
								<i class="spec-icon c-green">
									<svg width="24" height="24">
										<use xlink:href="#i__update"></use>
									</svg>
								</i>
								<span class="spec-label">Обновлено</span>
								<time class="spec-cont" itemprop="datePublished" datetime="{{ news.dateStamp|date("d-m-Y") }}T{{ news.dateStamp|date("H:i") }}">{{ news.dateStamp|date("d-m-Y, H:i") }}</time>
							</li>
							{% if (p.xfields.ver.value) %}
								<li class="specs-item">
									<i class="spec-icon c-green">
										<svg width="24" height="24">
											<use xlink:href="#i__vers"></use>
										</svg>
									</i>
									<span class="spec-label">Версия</span>
									<span class="spec-cont" itemprop="softwareVersion">{{ p.xfields.ver.value }}</span>
								</li>
							{% endif %}
							{% if (p.xfields.android.value) %}
								<li class="specs-item">
									<i class="spec-icon c-green">
										<svg width="24" height="24">
											<use xlink:href="#i__android"></use>
										</svg>
									</i>
									<span class="spec-label">Требования</span>
									<span class="spec-cont" itemprop="operatingSystem">Android {{ p.xfields.android.value }}</span>
								</li>
							{% endif %}
							<li class="specs-item">
								<i class="spec-icon c-green">
									<svg width="24" height="24">
										<use xlink:href="#i__cat"></use>
									</svg>
								</i>
								<span class="spec-label">Жанр</span>
								<span class="spec-cont" itemprop="applicationCategory">{{ news.categories.text }}</span>
							</li>
							<li class="specs-item">
								<i class="spec-icon c-green">
									<svg width="24" height="24">
										<use xlink:href="#i__getapp"></use>
									</svg>
								</i>
								<span class="spec-label">Просмотров</span>
								<span class="spec-cont">{{ news.views }}</span>
							</li>
							{% if (p.xfields.gplay.value) %}
								<li class="specs-item">
									<i class="spec-icon c-green">
										<svg width="24" height="24">
											<use xlink:href="#i__play"></use>
										</svg>
									</i>
									<span class="spec-label">Google Play</span>
									<div class="spec-cont fw-b" itemprop="applicationCategory">
										<a href="{{ p.xfields.gplay.value }}" rel="nofollow noopener" target="_blank" itemscope="" itemprop="offers" itemtype="http://schema.org/Offer">
											<meta itemprop="price" content="0">
											<meta itemprop="priceCurrency" content="USD">
											Открыть 
											<svg class="c-green" width="24" height="24">
												<use xlink:href="#i__linkopen"></use>
											</svg>
										</a>
									</div>
								</li>
							{% endif %}
						</ul>
					</div>
					<div class="view-app-rate">
						<div class="likes">
							<a href="#">
								<span class="like-plus">
									<svg width="24" height="24">
										<use xlink:href="#i__thumbup"></use>
									</svg>
									+0
								</span>
								<span class="sr-only">Нравится</span>
							</a>
							<a href="#">
								<span class="like-minus">
									<svg width="24" height="24">
										<use xlink:href="#i__thumbdown"></use>
									</svg>
									-0
									<span class="sr-only">Не нравится</span>
								</span>
							</a>
						</div>
						<ul class="rate-nums muted">
							<li>Оценок: 0</li>
							{% if pluginIsActive('comments') %}<li>Комментариев: {{ comnum }}</li>{% endif %}
						</ul>
					</div>
					<div class="btn-group">
						{% if (p.xfields.apk.value) %}
							<a class="btn btn-lg btn-icon s-green anchor" href="#download-block">
								<svg width="24" height="24">
									<use xlink:href="#i__getapp"></use>
								</svg>
								Скачать
							</a>
						{% endif %}
						<span class="btn btn-lg btn-border btn-complaint">
							<a href="#">Запросить обновление</a>
						</span>
					</div>
				</div>
			</div>
			<div class="block b-screens">
				<div class="b-icon-title">
					<i class="s-yellow c-icon">
						<svg width="24" height="24">
							<use xlink:href="#i__cam"></use>
						</svg>
					</i>
					<h3 class="b-title">Скриншоты{% if (p.xfields.trailer.value) %} и видео{% endif %}</h3>
				</div>
				<div class="b-cont">
					<div class="screenshots">
						{% if (p.xfields.trailer.value) %}
							<div class="app-video" data-src="{{ p.xfields.trailer.value }}">
								<div class="app-video-img">
									<button class="video_btn">
										<svg class="i__play" style="width: 1.5rem; height: 1.5rem;">
											<use xlink:href="#i__videoplay"></use>
										</svg>
										<span class="sr-only">Смотреть видео</span>
									</button>
									<i class="cover" style="background-image: url('{{ p.xfields.img.entries[0].purl }}');">
										<img src="{% if (news.embed.imgCount > 0) %}{{ news.embed.images[0] }}{% else %}{{ tpl_url }}/images/no_image.jpg{% endif %}" alt="{{ news.title }}" style="width: 196px; height: 109px;">
									</i>
								</div>
							</div>
						{% endif %}
						{% if not (p.xfields.img.count < 1) %}
							<a href="{{ p.xfields.img.entries[0].url }}" data-fancybox="gallery">
								<img data-src="{{ p.xfields.img.entries[0].purl }}" style="max-width:100%;" alt="" src="{{ p.xfields.img.entries[0].purl }}" >
							</a>
						{% endif %}
						{% if not (p.xfields.img.count < 2) %}
							<a href="{{ p.xfields.img.entries[1].url }}" data-fancybox="gallery">
								<img data-src="{{ p.xfields.img.entries[1].purl }}" style="max-width:100%;" alt="" src="{{ p.xfields.img.entries[1].purl }}" class="lazy-loaded">
							</a>
						{% endif %}
						{% if not (p.xfields.img.count < 3) %}
							<a href="{{ p.xfields.img.entries[2].url }}" data-fancybox="gallery">
								<img data-src="{{ p.xfields.img.entries[2].purl }}" style="max-width:100%;" alt="" src="{{ p.xfields.img.entries[2].purl }}" class="lazy-loaded">
							</a>
						{% endif %}
						{% if not (p.xfields.img.count < 4) %}
							<a href="{{ p.xfields.img.entries[3].url }}" data-fancybox="gallery">
								<img data-src="{{ p.xfields.img.entries[3].purl }}" style="max-width:100%;" alt="" src="{{ p.xfields.img.entries[3].purl }}" class="lazy-loaded">
							</a>
						{% endif %}
					</div>
				</div>
			</div>
		</div>
		<div class="background" style="display:none;">
			<div class="bg-img-blur">
				<i class="fit-cover">
					<img src="{% if (news.embed.imgCount > 0) %}{{ news.embed.images[0] }}{% else %}{{ tpl_url }}/images/no_image.jpg{% endif %}" alt="{{ news.title }}" width="10" height="10" loading="lazy">
				</i>
			</div>
			<i class="bg-circle-green"></i>
			<i class="bg-clouds">
				<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 2550 700" width="2550" height="700">
					<path fill="#142636" d="M554,100h-4A50,50,0,0,1,550,0h4a50,50,0,0,1,0,100Zm25,600H50a50,50,0,0,1,0-100h78.08a50,50,0,1,0,.11-100H98a50,50,0,0,1,0-100H238a50,50,0,0,0,0-100H194a50,50,0,0,1,0-100h56a50,50,0,0,0,.3-100H238A50,50,0,0,1,238,0H430a50,50,0,0,1,0,100H413.55a50,50,0,1,0,.05,100H630a50,50,0,0,1,0,100H521.55a50,50,0,1,0,0,100H526a50,50,0,0,1,0,100H445.55a50,50,0,0,0,.08,100H579a50,50,0,0,1,0,100Z"></path>
					<path fill="#142636" d="M2073,700a50,50,0,0,1,0-100h16.43a50,50,0,0,0,0-100H1901a50,50,0,0,1,0-100h216.42a50,50,0,0,0,0-100H2097a50,50,0,0,1-50-50h0a50,50,0,0,1,50-50h252a50,50,0,0,1,0,100h-28a50,50,0,0,0,0,100h24a50,50,0,0,1,0,100h-24a50,50,0,0,0,0,100h179a50,50,0,0,1,0,100Z"></path>
				</svg>
			</i>
		</div>
	</div>
	<div class="wrp-min block-list">
		<div class="block b-add-info">
			<div class="b-tabs" role="tablist">
				<a class="tab-item active" href="#app_description">Описание</a>
				<a class="tab-item" href="#app_faq">Помощь</a>
				{% if (news.flags.canEdit) %}<a href="{{ news.url.edit }}"><div lass="tab-item">{{ lang.editnews }}</div></a>{% endif %}
			</div>
			<div class="b-cont tab-content">
				<div class="tab-pane text" id="app_description" style="display: block;">
					{{ news.full }}
					{% for file in _files %}
						<a href="{{ file.url }}" class="download-line s-green" target="_blank">
							<div class="download-line-title"><i><svg width="24" height="24"><use xlink:href="#i__getapp"></use></svg></i><span>{{ file.origName }}</span></div>
							<span class="download-line-size">Скачать <span class="uppercase">apk</span> - 0</span>
						</a>
					{% endfor %}
				</div>
				<div class="tab-pane" id="app_faq" style="display: none;">
					<a class="link-faq" href="#">Установка игр и программ</a>
					<a class="link-faq" href="#">Установка игр с кэшем</a>
					<a class="link-faq" href="#">Как сделать скриншот</a>
				</div>
			</div>
		</div>
		{% if (p.xfields.apk.value) %}
			<div class="anchor-line">
				<span id="download-block"></span>
			</div>
			<div class="block b-download">
				<div class="b-nobugs">
					<div class="b-nobugs-icon">
						<figure class="img">
							<img src="{% if (news.embed.imgCount > 0) %}{{ news.embed.images[0] }}{% else %}{{ tpl_url }}/images/no_image.jpg{% endif %}" alt="{{ news.title }}" width="44" height="44" loading="auto">
						</figure>
						<i class="c-green">
							<svg width="24" height="24">
								<use xlink:href="#i__shield"></use>
							</svg>
						</i>
					</div>
					<div class="b-nobugs-text">
						<span>Скачать {{ news.title }} бесплатно</span>
					</div>
				</div>
				<div class="b-cont">
					<div class="downline-line-list">
						<a href="{{ p.xfields.apk.value }}" class="download-line s-green" target="_blank">
							<div class="download-line-title"><i><svg width="24" height="24"><use xlink:href="#i__getapp"></use></svg></i><span>{{ news.title }}</span></div>
							<span class="download-line-size">Скачать <span class="uppercase">apk</span></span>
						</a>
						{% if (p.xfields.mod.value) %}
							<a href="{{ p.xfields.mod.value }}" class="download-line s-green" target="_blank">
								<div class="download-line-title"><i><svg width="24" height="24"><use xlink:href="#i__getapp"></use></svg></i><span>Мод {{ news.title }}</span></div>
								<span class="download-line-size">Скачать <span class="uppercase">apk</span></span>
							</a>
						{% endif %}
					</div>
					{% if (p.xfields.info.value) %}
						<div class="spoiler">
							<div class="sp-head" onclick="toggleSpoiler(this.parentNode, this);">
								<b></b>
								Информация мода
							</div>
							<div class="sp-body">
								{{ p.xfields.info.value }}
							</div>
						</div>
					{% endif %}
				</div>
			</div>
		{% endif %}
		{% if pluginIsActive('comments') %}{{ plugin_comments }}{% endif %}
	</div>
</article>
{% if (p.xfields.trailer.value) %}
	<div class="modal videobox video_close" style="display:none;">
		<div class="video-content">
			<div class="video-wrap">
				<div class="video-body">
					<button class="close video_close" type="button">
						<svg width="24" height="24">
							<use xlink:href="#i__close"></use>
						</svg>
						<span class="sr-only">X</span>
					</button>
					<div class="video_block">
						<div class="video_wrap">{{ p.xfields.trailer.value }}</div>
						<img width="100%" src="{% if (news.embed.imgCount > 0) %}{{ news.embed.images[0] }}{% else %}{{ tpl_url }}/images/no_image.jpg{% endif %}" alt="{{ news.title }}" style="opacity: 0; visibility: hidden;">
					</div>
				</div>
			</div>
		</div>
	</div>
{% endif %}
{% endif %}
{% if isNews('cat:1') %}
<article class="view-news section" itemscope itemtype="http://schema.org/Article">
	<div class="view-news-head dark-head dark-section">
		<div class="wrp-min">
			<div class="vn-head-main">
				<h1 itemprop="name" class="title">{{ news.title }}</h1>
				<div class="meta muted">
					<time class="meta-date" datetime="{{ news.dateStamp|date("d-m-Y") }}T{{ news.dateStamp|date("H:i") }}">{{ news.dateStamp|date("d-m-Y, H:i") }}</time>
					<div class="meta-view">
						<svg width="24" height="24">
							<use xlink:href="#i__stats"></use>
						</svg>
						{{ news.views }}
					</div>
				</div>
			</div>
			<div class="likes">
				<a href="#"><span class="like-plus"><svg width="24" height="24"><use xlink:href="#i__thumbup"></use></svg>+0</span><span class="sr-only">Нравится</span></a>
				<a href="#"><span class="like-minus"><svg width="24" height="24"><use xlink:href="#i__thumbdown"></use></svg>-0<span class="sr-only">Не нравится</span></span></a>
			</div>
		</div>
		<div class="background" style="display:none;">
			<i class="bg-clouds">
				<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 2550 700" width="2550" height="700">
					<path fill="#142636" d="M554,100h-4A50,50,0,0,1,550,0h4a50,50,0,0,1,0,100Zm25,600H50a50,50,0,0,1,0-100h78.08a50,50,0,1,0,.11-100H98a50,50,0,0,1,0-100H238a50,50,0,0,0,0-100H194a50,50,0,0,1,0-100h56a50,50,0,0,0,.3-100H238A50,50,0,0,1,238,0H430a50,50,0,0,1,0,100H413.55a50,50,0,1,0,.05,100H630a50,50,0,0,1,0,100H521.55a50,50,0,1,0,0,100H526a50,50,0,0,1,0,100H445.55a50,50,0,0,0,.08,100H579a50,50,0,0,1,0,100Z" />
					<path fill="#142636" d="M2073,700a50,50,0,0,1,0-100h16.43a50,50,0,0,0,0-100H1901a50,50,0,0,1,0-100h216.42a50,50,0,0,0,0-100H2097a50,50,0,0,1-50-50h0a50,50,0,0,1,50-50h252a50,50,0,0,1,0,100h-28a50,50,0,0,0,0,100h24a50,50,0,0,1,0,100h-24a50,50,0,0,0,0,100h179a50,50,0,0,1,0,100Z" />
				</svg>
			</i>
		</div>
	</div>
	<div class="wrp-min block-list">
		<div class="block b-article">
			<div class="img">
				<figure class="fit-cover">
					<img src="{% if (news.embed.imgCount > 0) %}{{ news.embed.images[0] }}{% else %}{{ tpl_url }}/images/no_image.jpg{% endif %}" alt="{{ news.title }}" width="640" height="400">
				</figure>
			</div>
			<div class="b-cont">
				<div class="text">
					{{ news.full }}
				</div>
				{% if pluginIsActive('neighboring_news') %}{{ neighboring_news }}{% endif %}
			</div>
		</div>
		{% if pluginIsActive('comments') %}{{ plugin_comments }}{% endif %}
	</div>
</article>
{% endif %}
[/TWIG]