[TWIG]
<div class="entry entry-app">
	<div class="item">
		{% if news.dateStamp|date("d-m-Y") == "now"|date("d-m-Y") %}
			<span class='label label-new'>New</span>
		{% elseif news.dateStamp|date("d-m-Y") == "now-1 day"|date("d-m-Y") %}
			<span class='label label-new'>New</span>
		{% else %}
			{% if (news.flags.isUpdated) %}
				<span class="label label-up">Update</span>
			{% endif %}
		{% endif %}
		<figure class="img">
			<img src="{% if (news.embed.imgCount > 0) %}{{ news.embed.images[0] }}{% else %}{{ tpl_url }}/images/no_image.jpg{% endif %}" alt="{{ news.title }}" width="112" height="112" loading="lazy">
			<span class="post__edit"></span>
		</figure>
		<h2 class="title"><a class="item-link" href="{{ news.url.full }}"><span>{{ news.title }}</span></a></h2>
		<span class="genre truncate">{{ news.categories.text }}</span>
		<ul class="entry-app-info">
			{% if (p.xfields.android.value) %}
				<li>
					<svg width="24" height="24">
						<use xlink:href="#i__android"></use>
					</svg>
					<span class="truncate">{{ p.xfields.android.value }}</span>
				</li>
			{% endif %}
			{% if (p.xfields.ver.value) %}
				<li>
					<svg width="24" height="24">
						<use xlink:href="#i__vers"></use>
					</svg>
					<span class="truncate">{{ p.xfields.ver.value }}</span>
				</li>
			{% endif %}
		</ul>
	</div>
</div>
[/TWIG]