{% extends localPath(0) ~ "site.body.tpl" %}
{% block content %}
	{% if (flags.link_news) %}
		<div class="alert wrp-min">
			<div class="alert_in">
				<div class="alert-cont">
					Запрос по новости: <a href="{{ news.url }}">{{ news.title }}</a>
				</div>
			</div>
		</div>
	{% endif %}
	{{ description }}<br/><br/>
	{% if (flags.jcheck) %}
		<script language="JavaScript">
			var FBF_INIT = {{ FBF_DATA }};
			function FBF_CHECK() {
				var frm = document.getElementById('feedback_form');
				if (frm == null) return true;

				var i;
				for (i in FBF_INIT) {
					if (FBF_INIT[i][1]) {
						if (FBF_INIT[i][0] == 'date') {
							if ((frm[i + ':day'].value == '1') && (frm[i + ':month'].value == '1') && (frm[i + ':year'].value == '1970')) {
								alert('{l_feedback:form.err.notfilled} (' + FBF_INIT[i][2] + ')!');
								frm[i + ':day'].focus();
								return false;
							}
						} else if (frm[i].value == '') {
							alert('{l_feedback:form.err.notfilled} (' + FBF_INIT[i][2] + ')!');
							frm[i].focus();
							return false;
						}
					}
				}
				return true;
			}
		</script>
	{% endif %}
	<form method="post" action="{{ form_url }}" id="feedback_form" name="feedback_form">
		{{ hidden_fields }}
		<input type="hidden" name="id" value="{{ id }}"/>
		<ul class="ui-form">
			{% for entry in entries %}
				{% if entry.type == 'text' %}
					<li class="form-group">
						<label>{{ entry.title }}</label>
						<input type="text" name="{{ entry.name }}">
					</li>
				{% endif %}
				{% if entry.type == 'email' %}
					<li class="form-group">
						<label>{{ entry.title }}</label>
						<input type="text" name="{{ entry.name }}">
					</li>
				{% endif %}
				{% if entry.type == 'textarea' %}
					<li class="form-group">
						<label>{{ entry.title }}</label>
						<textarea name="{{ entry.name }}" rows="8">{{ entry.value }}</textarea>
					</li>
				{% endif %}
				{% if entry.type == 'select' %}
					<li class="form-group">
						<label>{{ entry.title }}</label>
						<select name="{{ entry.name }}">{{ entry.options.select }}</select>
					</li>
				{% endif %}
				{% if entry.type == 'date' %}
					<li class="form-group">
						<label>{{ entry.title }}</label>
						<select name="{{ entry.name }}:day" style="width: 33%;">{{ entry.options.day }}</select> <select name="{{ entry.name }}:month" style="width: 33%;">{{ entry.options.month }}</select> <select name="{{ entry.name }}:year" style="width: 33%;">{{ entry.options.year }}</select>
					</li>
				{% endif %}
			{% endfor %}
			{% if (flags.captcha) %}
				<li class="form-group">
					<div><img id="img_captcha" onclick="this.src='{{ captcha_url }}&rand='+Math.random();" src="{{ captcha_url }}&rand={{ captcha_rand }}" style="background:#fff;cursor:pointer;margin-bottom:5px;border:1px solid var(--form-control-brd);border-radius:.375rem;" alt="Security code" width="140" height="50" /></div>
					<div><input placeholder="{{ lang.theme.code }}" title="{{ lang.theme.code_info }}" type="text" name="vcode" style="width:140px;" required></div>
					
				</li>
			{% endif %}
			{% if (flags.recipients) %}
				<li class="form-group">
					<label>{{ lang['feedback:sform.elist'] }}</label>
					<select name="recipient">{{ recipients_list }}</select>
				</li>
			{% endif %}
		</ul>
		<div class="form_submit" style="margin-top:10px;">
			<button {% if (flags.jcheck) %}onclick="return FBF_CHECK();" {% endif %}class="btn btn-block s-green" type="submit">{{ lang.theme.send }}</button>
		</div>
	</form>
{% endblock %}