<form name="form" method="POST" action="{{ php_self }}?action=delete" style="display: inline;">
<div class="pm-box">
	{% if max_messages > 0 %}
		<div class="pm-status">
			<span class="pm-status-info">{{ current_messages }}% / ({{ max_messages }} {{ lang.theme.pm_max_messages }})</span>
			<div class="pm_progress_bar" title="{{ lang.theme.pm_current_messages }}: {{ current_messages }}%"><span style="width: {{ current_messages }}%">{{ current_messages }}%</span></div>
		</div>
	{% endif %}
	<ul class="pm-menu">
		<li><a href="{{ pm_inbox_link }}"><span>{{ lang['pm:inbox'] }}</span></a></li>
		<li><a href="{{ pm_outbox_link }}"><span>{{ lang['pm:outbox'] }}</span></a></li>
		<li><a href="{{ pm_set_link }}"><span>{{ lang['pm:set'] }}</span></a></li>
	</ul>
</div>
<div class="pmlist table_wide">
	<table width="100%" class="pm">
		<tr align="center">
			<td width="25%" class="pm_head">{{ lang['pm:date'] }}</td>
			<td width="40%" class="pm_head">{{ lang['pm:subject'] }}</td>
			<td width="30%" class="pm_head">{{ lang['pm:too'] }}</td>
			<td width="5%" class="pm_head"><input type="checkbox" name="master_box" title="{{ lang['pm:checkall'] }}" onclick="javascript:check_uncheck_all(form)"></td>
		</tr>
		{% for entry in entries %}
			<tr align="center">
				<td class="pm_list">{{ entry.pmdate|date('Y-m-d H:i') }}</td>
				<td class="pm_list"><a href="{{ php_self }}?action=read&pmid={{ entry.pmid }}&location=outbox">{{ entry.subject }}</a></td>
				<td class="pm_list">{{ entry.link }}</td>
				<td class="pm_list"><input name="selected_pm[]" value="{{ entry.pmid }}" type="checkbox"/></td>
			</tr>
		{% endfor %}
	</table>
</div>
<div class="form-submit">
	<button class="btn s-green btn-block" type="submit">{{ lang['pm:delete'] }}</button></form>
	<form name="pm" method="POST" action="{{ php_self }}?action=write" style="display: inline;">
		<button class="btn s-green btn-block" type="submit">{{ lang['pm:write'] }}</button>
	</form>
</div>
{% if pagination %}
	<div class="wrp-min">
		<div class="navigation">
			<div class="pages"><nav class="pages-list">{{ pagination }}</nav></div>
		</div>
	</div>
{% endif %}
<style type="text/css">
.navigation{display:flex;width:100%;margin-top:2rem;position:relative;text-align:center}
.pages-list{display:flex;margin:0 auto}
.pages-list>*,.page_prev>*,.page_next>*{display:block;line-height:1.5rem;height:2.5rem;font-weight:700;padding:.5rem;border-radius:2rem;transition:background-color ease .2s,color ease .2s}
.page_prev{margin-right:.5rem}
.page_next{margin-left:.5rem}
.page_prev>a,.page_next>a{background-color:#45c368;color:#fff;background-image:linear-gradient(180deg,#4CCB70 0%,#3DBA60 100%);box-shadow:0 .25rem .5rem 0 rgba(69,195,104,.3)}
.page_prev>span,.page_next>span{opacity:.5;color:#fff;background-color:rgba(23,43,61,.2)}
@media(max-width:767px){
.pages-list{margin:-1.5rem 0;padding:1.5rem 0;overflow:hidden;overflow-x:auto;-webkit-overflow-scrolling:touch}
.pages-list span:not(.nav_ext){color:#4ccb70}
.pages-list::after,.pages-list::before{content:"";max-width:1rem;min-width:1rem;height:1rem}.pages-list>*{padding-left:.75rem;padding-right:.75rem}
.pages{overflow:hidden;background-color:var(--block-bg);position:relative}
.pages::after,.pages::before{content:"";position:absolute;z-index:1;top:0;width:2rem;height:100%;pointer-events:none;border-radius:1.25rem}
.pages::before{border-bottom-right-radius:0;border-top-right-radius:0;left:0;background-image:linear-gradient(90deg,var(--block-bg) 0%,var(--block-bg-transp) 100%)}
.pages::after{border-bottom-left-radius:0;border-top-left-radius:0;right:0;background-image:linear-gradient(-90deg,var(--block-bg) 0%,var(--block-bg-transp) 100%)}}
@media(min-width:768px){
.pages-list>*{margin:0 .125rem}.pages-list>*,.page_prev>*,.page_next>*{font-size:1.125rem;min-width:2.5rem}
.pages-list span:not(.nav_ext){background-color:#f9bd3b;color:#fff;background-image:linear-gradient(180deg,#FEDE4A 0%,#F8B035 100%);box-shadow:0 .25rem .5rem 0 rgba(251,205,66,.3)}}
@media(min-width:992px){.pages-list a:hover{background-color:rgba(76,203,112,.1);color:#4ccb70}}
</style>