<script type="text/javascript">

    $( document ).ready(function() {
        var registrationValidator = (function() {

            var validateFields = function() {

                $("#reg_login").change(function() {

                    if ($('#reg_login').val() == '') {
                        $("#reg_login").css({
                            "display": "table-cell",
                            "background": "#f9f9f9",
                            "border": "1px solid #e2e2e2",
                            "box-shadow": "inset 2px 3px 3px -2px #e2e2e2"
                        });
                        $("div#reg_login").html("<span>{{ lang.auth_login_descr }}</span>");
                        return;
                    }

                    $.post('/engine/rpc.php', { json : 1, methodName : 'core.registration.checkParams', rndval: new Date().getTime(), params : json_encode({ 'login' : $('#reg_login').val() }), dataType: 'json' }, function(data) {
                        if(typeof data == 'string') {
                            resTX = $.parseJSON(data);
                        } else {
                            resTX = data;
                        }
                        if (!resTX['status']) {
                            alert('Error ['+resTX['errorCode']+']: '+resTX['errorText']);
                        } else {
                            if ((resTX['data']['login']>0)&&(resTX['data']['login'] < 100)) {
                                $("#reg_login").css("border-color", "#b54d4b");
                                $("div#reg_login").html("<span style='color:#b54d4b;'>{{ lang.theme.registration_msg_login_warning }}</span>");
                            } else {
                                $("#reg_login").css("border-color", "#94c37a");
                                $("div#reg_login").html("<span style='color:#94c37a;'>{{ lang.theme.registration_msg_login_success }}</span>");
                            }
                        }
                    }, "text").error(function() {
                        alert('HTTP error during request', 'ERROR');
                    });

                });

                $("#reg_email").change(function() {

                    if ($('#reg_email').val() == '') {
                        $("#reg_email").css({
                            "display": "table-cell",
                            "background": "#f9f9f9",
                            "border": "1px solid #e2e2e2",
                            "box-shadow": "inset 2px 3px 3px -2px #e2e2e2"
                        });
                        $("div#reg_email").html("<span>{{ lang.auth_email_descr }}</span>");
                        return;
                    }

                    $.post('/engine/rpc.php', { json : 1, methodName : 'core.registration.checkParams', rndval: new Date().getTime(), params : json_encode({ 'email' : $('#reg_email').val() }), dataType: 'json' }, function(data) {
                        if(typeof data == 'string') {
                            resTX = $.parseJSON(data);
                        } else {
                            resTX = data;
                        }
                        if (!resTX['status']) {
                            alert('Error ['+resTX['errorCode']+']: '+resTX['errorText']);
                        } else {
                            if ((resTX['data']['email']>0)&&(resTX['data']['email'] < 100)) {
                                $("#reg_email").css("border-color", "#b54d4b");
                                $("div#reg_email").html("<span style='color:#b54d4b;'>{{ lang.theme.registration_msg_email_warning }}</span>");
                            } else {
                                $("#reg_email").css("border-color", "#94c37a");
                                $("div#reg_email").html("<span style='color:#94c37a;'>{{ lang.theme.registration_msg_email_success }}</span>");
                            }
                        }
                    }).error(function() {
                        alert('HTTP error during request', 'ERROR');
                    });

                });


                $("#reg_password2").change(function() {

                    if ($('#reg_password2').val() == '' && $('#reg_password').val() == '') {
                        $("#reg_password").css({
                            "display": "table-cell",
                            "background": "#f9f9f9",
                            "border": "1px solid #e2e2e2",
                            "box-shadow": "inset 2px 3px 3px -2px #e2e2e2"
                        });
                        $("#reg_password2").css({
                            "display": "table-cell",
                            "background": "#f9f9f9",
                            "border": "1px solid #e2e2e2",
                            "box-shadow": "inset 2px 3px 3px -2px #e2e2e2"
                        });
                        $("div#reg_password2").html("<span>{{ lang.auth_pass2_descr }}</span>");
                        return;
                    }

                    if ($('#reg_password2').val() != $('#reg_password').val()) {
                        $("#reg_password").css("border-color", "#b54d4b");
                        $("#reg_password2").css("border-color", "#b54d4b");
                        $("div#reg_password2").html("<span style='color:#b54d4b;'>{{ lang.theme.registration_msg_password_warning }}</span>");
                    } else {
                        $("#reg_password").css("border-color", "#94c37a");
                        $("#reg_password2").css("border-color", "#94c37a");
                        $("div#reg_password2").html("<span style='color:#94c37a;'>{{ lang.theme.registration_msg_password_success }}</span>");
                    }


                });


                $("#reg_password").change(function() {

                    if ($('#reg_password2').val() == '' && $('#reg_password').val() == '') {
                        $("#reg_password").css({
                            "display": "table-cell",
                            "background": "#f9f9f9",
                            "border": "1px solid #e2e2e2",
                            "box-shadow": "inset 2px 3px 3px -2px #e2e2e2"
                        });
                        $("#reg_password2").css({
                            "display": "table-cell",
                            "background": "#f9f9f9",
                            "border": "1px solid #e2e2e2",
                            "box-shadow": "inset 2px 3px 3px -2px #e2e2e2"
                        });
                        $("div#reg_password2").html("<span>{{ lang.auth_pass2_descr }}</span>");
                        return;
                    }
                    if ($('#reg_password2').val() != $('#reg_password').val()) {
                        $("#reg_password").css("border-color", "#b54d4b");
                        $("#reg_password2").css("border-color", "#b54d4b");
                        $("div#reg_password2").html("<span style='color:#b54d4b;'>{{ lang.theme.registration_msg_password_warning }}</span>");
                    } else {
                        $("#reg_password").css("border-color", "#94c37a");
                        $("#reg_password2").css("border-color", "#94c37a");
                        $("div#reg_password2").html("<span style='color:#94c37a;'>{{ lang.theme.registration_msg_password_success }}</span>");
                    }


                });

            };

            return {
                validateFields: validateFields
            };

        })();

        registrationValidator.validateFields();
    });

</script>
<form name="register" action="{{ form_action }}" method="post" onsubmit="return validate();">
<input type="hidden" name="type" value="doregister" />
<div class="page_form__inner">
	<h1 class="title h1">
		{{ lang.registration }}
	</h1>
	<div class="page_form__form">
		<div class="regtext">
			Регистрация на нашем сайте позволит Вам быть его полноценным участником.
			Вы сможете добавлять новости на сайт, оставлять свои комментарии, просматривать скрытый текст и многое другое.
			<br>В случае возникновения проблем с регистрацией, обратитесь к администратору сайта.
		</div>
		<ul class="ui-form">
			{% for entry in entries %}
				{% if entry.type == 'input' %}
					<li class="form-group">
						<label>{{ entry.title }}</label>
						<input id="{{ entry.id }}" type="{{ entry.type }}" name="{{ entry.name }}" value="{{ entry.value }}" required>
						<div id="{{entry.id}}">{{ entry.descr }}</div>
					</li>
				{% endif %}
				{% if entry.type == 'password' %}
					<li class="form-group">
						<label>{{ entry.title }}</label>
						<input id="{{ entry.id }}" type="{{ entry.type }}" name="{{ entry.name }}" value="{{ entry.value }}" required>
						<div id="{{entry.id}}">{{ entry.descr }}</div>
					</li>
				{% endif %}
				{% if entry.type == 'text' %}
					<li class="form-group">
						<label>{{ entry.title }}</label>
						<textarea name="{{ entry.name }}" rows="5"></textarea>
					</li>
				{% endif %}
				{% if entry.type == 'select' %}
					<li class="form-group">
						<label>{{ entry.title }}</label>
						<select type="{{ entry.type }}" name="{{ entry.name }}">{% for key,value in entry.values %}<option value="{{ key }}">{{ value }}</option>{% endfor %}</select>
					</li>
				{% endif %}
			{% endfor %}
			{% if flags.hasCaptcha %}
				<li class="form-group">
					<div><img src="{{ admin_url }}/captcha.php?id=registration&force=1&rand={{ random() }}" onclick="reload_captcha();" id="img_captcha" style="background:#fff;cursor:pointer;margin-bottom:5px;border:1px solid var(--form-control-brd);border-radius:.375rem;" alt="Security code" width="140" height="50" /></div>
					<div><input placeholder="{{ lang.theme.code }}" title="{{ lang.theme.code_info }}" type="text" name="vcode" style="width:140px;" required></div>
				</li>
			{% endif %}
			<li class="form-group">
				<div class="custom-control custom-checkbox">
					<input type="checkbox" name="agree" class="custom-control-input" id="agree">
					<label class="custom-control-label" for="agree">{{ lang.theme.registration_rules }}</label>
				</div>
			</li>
		</ul>
		<div class="form_submit">
			<button class="btn btn-block s-green" type="submit">{{ lang.register }}</button>
		</div>
	</div>
</div>
</form>
<script type="text/javascript">
	function validate() {
		if (document.register.agree.checked == false) {
			window.alert('{{ lang.theme.registration_check_rules }}');
			return false;
		}
		return true;
	}
	var ADMIN_URL = "{{ admin_url }}";
	function reload_captcha() {
		let img = document.getElementById('img_captcha');
		if (img) {
			img.src = ADMIN_URL + '/captcha.php?id=registration&force=1&rand=' + Math.random();
		}
	}
</script>