{% if (global.flags.isLogged) %}
	<div class="dropdown userpanel">
		<button class="dropdown-btn" data-toggle="dropdown" id="login_drop" aria-haspopup="true" aria-expanded="false">
			<i class="avatar fit-cover">
				<img src="{{ avatar_url }}" alt="{{ global.user.name }}">
			</i>
		</button>
		<div class="dropdown-menu dropdown-form dropdown-menu-right" aria-labelledby="login_drop" style="display:none;">
			<div class="login-pane__info">
				<a {% if pluginIsActive('uprofile') %}href="{{ user_link }}"{% endif %} class="avatar fit-cover">
					<img src="{{ avatar_url }}" alt="{{ global.user.name }}">
				</a>
				<div class="title">
					{% if pluginIsActive('uprofile') %}<a href="{{ user_link }}">{% endif %}
						{{ global.user.name }}
					{% if pluginIsActive('uprofile') %}</a>{% endif %}
				</div>
			</div>
			<ul class="login-pane__menu">
				{% if (global.flags.isLogged and (global.user['status'] <= 3)) %}
					<li><a href="{{ admin_url }}" target="_blank">{{ lang.admin_panel }}</a></li>
				{% endif %}
				{% if pluginIsActive('nsm') %}
					<li><a href="{{ p.nsm.link }}">{{ lang.add_news }}</a></li>
				{% endif %}
				{% if pluginIsActive('uprofile') %}
					<li><a href="{{ user_link }}">{{ lang.myprofile }}</a></li>
					<li><a href="{{ profile_link }}">{{ lang.edit_profile }}</a></li>
				{% endif %}
				{% if pluginIsActive('pm') %}
					<li><a href="{{ p.pm.link }}">{{ lang.private_messages }} <span class="f-right muted"><b>{{ p.pm.pm_unread }}</b> / {{ p.pm.pm_all }}</span></a></li>
				{% endif %}
				{% if pluginIsActive('bookmarks') %}
					<li><a href="{{ p.bookmarks.link }}">Мои закладки <span class="f-right muted"><b>{{ p.bookmarks.count }}</b></span></a></li>
				{% endif %}
				<li><a href="{{ logout_link }}">{{ lang.log_out }}</a></li>
			</ul>
		</div>
	</div>
{% else %}
	<script language="javascript">
		var set_login = 0;
		var set_pass  = 0;
	</script>
	<div class="modal-head">
		<button type="button" class="close" data-dismiss="modal" aria-label="Close">
			<svg width="24" height="24">
				<use xlink:href="#i__close"></use>
			</svg>
		</button>
		<h3 class="modal-title" style="text-align: left;">Войти на 5play.ru</h3>
		<div class="social-links">
			<a class="soc-vk" href="#" target="_blank" rel="nofollow noopener">
				<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32" width="32" height="32">
					<path fill="#fff" d="M15.52,21.17H16.7a.9.9,0,0,0,.54-.22.56.56,0,0,0,.11-.54s0-1.5.75-1.72,1.62,1.51,2.58,2.15a1.43,1.43,0,0,0,1.3.33h2.58s1.4-.11.75-1.19c0-.11-.43-.75-1.94-2.15s-1.4-1.18.54-3.77c1.19-1.5,1.72-2.47,1.51-2.9s-1.08-.32-1.08-.32h-2.9a1,1,0,0,0-.43.1,1.66,1.66,0,0,0-.22.32,14.16,14.16,0,0,1-1.07,2.26c-1.29,2.16-1.83,2.26-2,2.16-.54-.32-.32-1.29-.32-1.94,0-2,.32-2.9-.65-3.12a3.15,3.15,0,0,0-1.29-.21,7.62,7.62,0,0,0-2.47.21c-.33.22-.65.54-.43.54a1.08,1.08,0,0,1,.86.43,2.65,2.65,0,0,1,.32,1.29s.22,2.48-.43,2.8c-.43.22-1-.21-2.15-2.15A11.69,11.69,0,0,1,10,11.38a1.46,1.46,0,0,0-.22-.33l-.43-.21H6.58s-.43,0-.53.21,0,.43,0,.43,2.15,5,4.63,7.43a6.82,6.82,0,0,0,4.84,2.25" />
				</svg>
			</a>
			<a class="soc-fb" href="#" target="_blank" rel="nofollow noopener">
				<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32" width="32" height="32">
					<path fill="#fff" d="M18.3,11.24h1.09V9.12A12.58,12.58,0,0,0,17.46,9a3.06,3.06,0,0,0-3.28,2.8,3.49,3.49,0,0,0,0,.56v1.9H12v2.5h2.19v6.14h2.7V16.71h2l.38-2.5h-2.4V12.59A1.24,1.24,0,0,1,18,11.24Z" />
				</svg>
			</a>
			<a class="soc-ok" href="#" target="_blank" rel="nofollow noopener">
				<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32" width="32" height="32">
					<path fill="#fff" d="M14,19.65a7.78,7.78,0,0,1-2.4-1,1.21,1.21,0,1,1,1.29-2,5.28,5.28,0,0,0,5.57,0,1.21,1.21,0,1,1,1.29,2,7.68,7.68,0,0,1-2.4,1L19.63,22a1.21,1.21,0,0,1-1.71,1.72L15.64,21.4l-2.27,2.27A1.21,1.21,0,0,1,11.65,22L14,19.65m1.67-9.23a1.72,1.72,0,1,0,1.72,1.72,1.72,1.72,0,0,0-1.72-1.72Zm0,5.85a4.14,4.14,0,1,1,4.14-4.14h0a4.14,4.14,0,0,1-4.14,4.14Z" />
				</svg>
			</a>
			<a class="soc-gl" href="#" target="_blank" rel="nofollow noopener">
				<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32" width="32" height="32">
					<path fill="#fbbb00" d="M11.56,17.67,11,19.76l-2,0a8,8,0,0,1-.06-7.5h0l1.82.34.8,1.8a4.78,4.78,0,0,0,0,3.23Z" />
					<path fill="#518ef8" d="M23.91,14.5a8,8,0,0,1-2.86,7.76h0l-2.29-.12-.32-2a4.88,4.88,0,0,0,2.06-2.44H16.2V14.5Z" />
					<path fill="#28b446" d="M21.05,22.26h0A8,8,0,0,1,9.76,21,9.33,9.33,0,0,1,9,19.8l2.6-2.13a4.79,4.79,0,0,0,6.15,2.8,4.46,4.46,0,0,0,.73-.35Z" />
					<path fill="#f14336" d="M21.15,9.82,18.55,12A4.77,4.77,0,0,0,12,13.48a4.83,4.83,0,0,0-.47,1L8.9,12.31h0A8,8,0,0,1,21.15,9.82Z" />
				</svg>
			</a>
		</div>
	</div>
	<div class="modal-body">
		<form class="login_form" name="login" method="post" action="{{ form_action }}" id="login">
			<div class="login_form" style="text-align: left;">
				<label class="form-group">
					<span class="c-muted">{{ lang.username }}</span>
					<input class="form-control" type="text" name="username" required>
				</label>
				<label class="form-group">
					<a class="f-right" href="{{ lost_link }}">{{ lang.lostpassword }}</a>
					<span class="c-muted">{{ lang.password }}</span>
					<input class="form-control" type="password" name="password" required>
				</label>
				<input type="hidden" name="redirect" value="{{ redirect }}" />
				<div class="form-submit btn-group">
					<button class="btn btn-block s-green" type="submit">{{ lang.login }}</button>
					<a href="{{ reg_link }}" class="btn btn-block s-yellow">{{ lang.registration }}</a>
				</div>
			</div>
		</form>
	</div>
{% endif %}