<!DOCTYPE html>
<!--[TWIG]-->
<html class="no-js" lang="">
	<head>
		<meta http-equiv="content-type" content="text/html; charset={{ lang['encoding'] }}" />
		<meta http-equiv="content-language" content="{{ lang['langcode'] }}" />
		<meta name="generator" content="{{ what }} {{ version }}" />
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
		{{ htmlvars }}
		<link href="https://fonts.googleapis.com/css2?family=Nunito:ital,wght@0,300;0,400;0,600;0,700;0,800;0,900;1,400&display=swap" rel="stylesheet">
		<link rel="icon" href="{{ tpl_url }}/images/favicon.ico" type="image/x-icon">
		<link rel="stylesheet" href="{{ tpl_url }}/css/bootstrap.min.css">
		<link rel="stylesheet" href="{{ tpl_url }}/css/icofont.min.css">
		<link rel="stylesheet" href="{{ tpl_url }}/css/sal.css">
		<link rel="stylesheet" href="{{ tpl_url }}/css/jquery.mCustomScrollbar.min.css">
		<link rel="stylesheet" href="{{ tpl_url }}/css/select2.min.css">
		<link rel="stylesheet" href="{{ tpl_url }}/css/app.css">
		<link rel="stylesheet" href="{{ tpl_url }}/css/engine.css">
		{% if pluginIsActive('rss_export') %}<link href="{{ home }}/rss.xml" rel="alternate" type="application/rss+xml" title="RSS" />{% endif %}
		<script type="text/javascript" src="{{ scriptLibrary }}/functions.js"></script>
		<script type="text/javascript" src="{{ scriptLibrary }}/ajax.js"></script>
		<title>{{ titles }}</title>
	</head>
	<body class="bg-link-water">
		{% block body %}
			<div id="wrapper" class="wrapper">
				{% include "includes/header.tpl" %}
				{% include "includes/sidemenu.tpl" %}
				<div class="page-content">
					<div class="container">
						<div class="row">
							<div class="col-lg-{% if isHandler('news:news|comments|nsm') %}12{% else %}8{% endif %}" id="article">
								{% if isHandler('news:main') %}
									<div class="newsfeed-search">
										<ul class="member-list">
											<li class="active-member"><a href="#"><span class="member-icon"><i class="icofont-page"></i></span><span class="member-text">Новые публикации</span></a></li>
										</ul>
										<ul class="search-list">
											<li class="search-filter">
												<button class="drop-btn" type="button">
													<i class="icofont-abacus-alt"></i> 
													<span style="font-size:13px">Сортировать</span>
												</button>
												<div class="drop-menu" style="width:650px">
													<form>
														<ul class="sort">
															<li class="asc sort_by_date"><a href="#">дате</a></li>
															<li class="sort_by_editdate"><a href="#">дате изменения</a></li>
															<li class="sort_by_rating"><a href="#">популярности</a></li>
															<li class="sort_by_news_read"><a href="#">посещаемости</a></li>
															<li class="sort_by_comm_num"><a href="#">комментариям</a></li>
															<li class="sort_by_title"><a href="#">алфавиту</a></li>
														</ul>
													</form>
												</div>
											</li>
										</ul>
									</div>
								{% endif %}
								<div id='dle-content'>{{ mainblock }}</div>
							</div>
							{% if not isHandler('news:news|comments|nsm') %}
								{% include "includes/sidebar.tpl" %}
							{% endif %}
						</div>
					</div>
				</div>
				{% include "includes/footer.tpl" %}
			</div>
			<a href="#wrapper" data-type="section-switch" class="scrollup"><i class="icofont-bubble-up"></i></a>
			<script type="text/javascript" src="{{ tpl_url }}/js/jquery.js"></script>
			<script type="text/javascript" src="{{ tpl_url }}/js/jqueryui.js"></script>
			<div id="loading-layer" style="display:none"><div class="loading-layer"></div></div>
			<script src="{{ tpl_url }}/js/popper.min.js"></script>
			<script src="{{ tpl_url }}/js/bootstrap.min.js"></script>
			<script src="{{ tpl_url }}/js/sal.js"></script>
			<script src="{{ tpl_url }}/js/jquery.mCustomScrollbar.concat.min.js"></script>
			<script src="{{ tpl_url }}/js/select2.min.js"></script>
			<script src="{{ tpl_url }}/js/jquery.elevatezoom.js"></script>
			<script src="{{ tpl_url }}/js/app.js"></script>
		{% endblock %}
	</body>
</html>
<!--[/TWIG]-->