{% extends localPath(0) ~ "site.body.tpl" %}
{% block content %}
	{% if (flags.link_news) %}
		<div class="alert alert-danger fs-13">
			<b>Запрос по новости: <a href="{{ news.url }}">{{ news.title }}</a></b>
		</div>
	{% endif %}
	{{ description }}<br/><br/>
	{% if (flags.jcheck) %}
		<script language="JavaScript">
			var FBF_INIT = {{ FBF_DATA }};
			function FBF_CHECK() {
				var frm = document.getElementById('feedback_form');
				if (frm == null) return true;

				var i;
				for (i in FBF_INIT) {
					if (FBF_INIT[i][1]) {
						if (FBF_INIT[i][0] == 'date') {
							if ((frm[i + ':day'].value == '1') && (frm[i + ':month'].value == '1') && (frm[i + ':year'].value == '1970')) {
								alert('{l_feedback:form.err.notfilled} (' + FBF_INIT[i][2] + ')!');
								frm[i + ':day'].focus();
								return false;
							}
						} else if (frm[i].value == '') {
							alert('{l_feedback:form.err.notfilled} (' + FBF_INIT[i][2] + ')!');
							frm[i].focus();
							return false;
						}
					}
				}
				return true;
			}
		</script>
	{% endif %}
	<form method="post" action="{{ form_url }}" id="feedback_form" name="feedback_form">
		{{ hidden_fields }}
		<input type="hidden" name="id" value="{{ id }}"/>
		{% for entry in entries %}
			{% if entry.type == 'text' %}
				<div class="form-group">
					<label>{{ entry.title }}</label>
					<input type="text" name="{{ entry.name }}">
				</div>
			{% endif %}
			{% if entry.type == 'email' %}
				<div class="form-group">
					<label>{{ entry.title }}</label>
					<input type="text" name="{{ entry.name }}">
				</div>
			{% endif %}
			{% if entry.type == 'textarea' %}
				<div class="form-group">
					<label>{{ entry.title }}</label>
					<textarea name="{{ entry.name }}" rows="8">{{ entry.value }}</textarea>
				</div>
			{% endif %}
			{% if entry.type == 'select' %}
				<div class="form-group">
					<label>{{ entry.title }}</label>
					<select name="{{ entry.name }}">{{ entry.options.select }}</select>
				</div>
			{% endif %}
			{% if entry.type == 'date' %}
				<div class="form-group">
					<label>{{ entry.title }}</label>
					<div><select name="{{ entry.name }}:day" style="width:33%;display:inline;">{{ entry.options.day }}</select> <select name="{{ entry.name }}:month" style="width:33%;display:inline;">{{ entry.options.month }}</select> <select name="{{ entry.name }}:year" style="width:33%;display:inline;">{{ entry.options.year }}</select></div>
				</div>
			{% endif %}
		{% endfor %}
		{% if (flags.captcha) %}
			<div class="form-group">
				<span><img id="img_captcha" onclick="this.src='{{ captcha_url }}&rand='+Math.random();" src="{{ captcha_url }}&rand={{ captcha_rand }}" style="background: #fff; cursor: pointer;" width="120" height="40" alt="Security code" /></span>
				<input placeholder="{{ lang.theme.code }}" title="{{ lang.theme.code_info }}" type="text" name="vcode" style="width:120px" required>
			</div>
		{% endif %}
		{% if (flags.recipients) %}
			<div class="form-group">
				<label>{{ lang['feedback:sform.elist'] }}</label>
				<select name="recipient">{{ recipients_list }}</select>
			</div>
		{% endif %}
		<div class="form_submit">
			<button {% if (flags.jcheck) %}onclick="return FBF_CHECK();" {% endif %}class="bbcodes bg-primary" type="submit">{{ lang.theme.send }}</button>
		</div>
	</form>
{% endblock %}