{% if comnum == 0 %}
	<div class="alert alert-danger fs-13">
		{{ lang['lastcomments:lastcomments_no'] }}
	</div>
{% else %}
	<div class="widget widget-memebers widget-activity">
		<div class="widget-heading"><h3 class="widget-title">{{ lang['lastcomments:lastcomments'] }}</h3></div>
		<div class="activity-list">
			{% for entry in entries %}
				<div class="media">
					<div class="item-img">
						{% if (entry.author_id) and (pluginIsActive('uprofile')) %}<a href="{{ entry.author_link }}">{% endif %}
							<img src="{{ entry.avatar_url }}" width="44px" alt="{{ entry.author.name }}">
						{% if (entry.author_id) and (pluginIsActive('uprofile')) %}</a>{% endif %}
					</div>
					<div class="media-body">
						<h4 class="item-title mb-1">{% if (entry.author_id) and (pluginIsActive('uprofile')) %}<a href="{{ entry.author_link }}" class="author-name">{% endif %}{{ entry.author }}{% if (entry.author_id) and (pluginIsActive('uprofile')) %}</a>{% endif %}</h4>
						<div class="activity-time mb-2"><i class="icofont-calendar"></i> {{ entry.date }}</div>
						<div style="line-height:150%;font-size:13px">
							{{ entry.text|truncateHTML(100,'...')|striptags }}
							{% if (row.answer != "") %}<br />--------------------<br /><i>{{ lang.theme.answer_from }}</i> <b>{{ entry.name }}</b><br />{{ entry.answer }}{% endif %}
						</div>
						<a href="{{ entry.link }}"><i class="icofont-reply"></i> Ответить</a>
					</div>
				</div>
			{% endfor %}
		</div>
		<a href="{{ lastcomments_url }}" class="bbcodes btn-block mt-3">{{ lang.theme.lastcomments_all }}</a>
	</div>
{% endif %}