{% if comnum == 0 %}
	<div class="alert alert-danger fs-13">
		{{ lang['lastcomments:lastcomments_no'] }}
	</div>
{% else %}
	<h1 class="item-title-page">{{ lang['lastcomments:lastcomments'] }}</h1>
	<div class="post-view">
		<div class="post-comment border-top-0">
			<ul class="comment-list pl-0 pr-0 border-bottom-0">
				{% for entry in entries %}
					<li class="main-comments border-bottom pb-3 mb-4 bg-white p-4 rounded">
						<div class="each-comment">
							<div class="post-header mt-0 pt-0">
								<div class="media">
									<div class="user-img">
										{% if (entry.author_id) and (pluginIsActive('uprofile')) %}<a href="{{ entry.author_link }}">{% endif %}
											<img src="{{ entry.avatar_url }}" width="40px" alt="{{ entry.author.name }}">
										{% if (entry.author_id) and (pluginIsActive('uprofile')) %}</a>{% endif %}
									</div>
									<div class="media-body">
										<div class="user-title">{% if (entry.author_id) and (pluginIsActive('uprofile')) %}<a href="{{ entry.author_link }}">{% endif %}{{ entry.author }}{% if (entry.author_id) and (pluginIsActive('uprofile')) %}</a>{% endif %}</div>
										<ul class="entry-meta">
											<!--<li class="meta-privacy"><i class="icofont-group"></i>{group}</li>-->
											<li class="meta-time">{{ entry.date }}</li>
										</ul>
									</div>
								</div>
							</div>
							<div class="post-body">
								<h4><a href="{{ entry.link }}">{{ entry.title }}</a></h4>
								{{ entry.text }}
								{% if (row.answer != "") %}<br />--------------------<br /><i>{{ lang.theme.answer_from }}</i> <b>{{ entry.name }}</b><br />{{ entry.answer }}{% endif %}
							</div>
						</div>
					</li>
				{% endfor %}
			</ul>
		</div>
	</div>
{% endif %}