<form name="form" method="POST" action="{{ php_self }}?action=delete" style="display: inline;">
<div class="card-body bg-white rounded">
	<h1 class="item-title-page">{{ lang['pm:pm'] }}</h1>
	<div class="row mb-4">
		<div class="col-4"><a class="bbcodes btn-block text-center bg-primary" href="{{ pm_inbox_link }}">{{ lang['pm:inbox'] }}</a></div>
		<div class="col-4"><a class="bbcodes btn-block text-center bg-primary" href="{{ pm_outbox_link }}">{{ lang['pm:outbox'] }}</a></div>
		<div class="col-4"><a class="bbcodes btn-block text-center bg-primary" href="{{ pm_set_link }}">{{ lang['pm:set'] }}</a></div>
	</div>
	{% if max_messages > 0 %}
		<div class="fs-13">Папки персональных сообщений заполнены на:</div>
		<div class="pm_progress_bar" title="{{ lang.theme.pm_current_messages }}: {{ current_messages }}%"><span style="width: {{ current_messages }}%">{{ current_messages }}%</span></div>
		<div class="fs-13">{{ current_messages }}% от лимита ({{ max_messages }} {{ lang.theme.pm_max_messages }})</div>
	{% endif %}
	<div class="fs-13">
		<table width="100%" class="pm">
			<tr align="center">
				<td width="25%" class="pm_head">{{ lang['pm:date'] }}</td>
				<td width="40%" class="pm_head">{{ lang['pm:subject'] }}</td>
				<td width="30%" class="pm_head">{{ lang['pm:too'] }}</td>
				<td width="5%" class="pm_head"><input type="checkbox" name="master_box" title="{{ lang['pm:checkall'] }}" onclick="javascript:check_uncheck_all(form)"></td>
			</tr>
			{% for entry in entries %}
				<tr align="center">
					<td class="pm_list">{{ entry.pmdate|date('Y-m-d H:i') }}</td>
					<td class="pm_list"><a href="{{ php_self }}?action=read&pmid={{ entry.pmid }}&location=outbox">{{ entry.subject }}</a></td>
					<td class="pm_list">{{ entry.link }}</td>
					<td class="pm_list"><input name="selected_pm[]" value="{{ entry.pmid }}" type="checkbox"/></td>
				</tr>
			{% endfor %}
		</table>
	</div>
	<div class="form_submit mt-3">
		<button class="bbcodes bg-danger" type="submit">{{ lang['pm:delete'] }}</button></form>
		<form name="pm" method="POST" action="{{ php_self }}?action=write" style="display: inline;">
			<button class="bbcodes bg-primary" type="submit">{{ lang['pm:write'] }}</button>
		</form>
	</div>
</div>
{% if pagination %}
	<div class="navigation">
		<div class="pages">
			<nav class="pages-list">{{ pagination }}</nav>
		</div>
	</div>
{% endif %}