<script type="text/javascript" src="{{ scriptLibrary }}/libsuggest.js"></script>
<style>
.suggestWindow {
	background: #ffffff;
	border: 1px solid #3394e6;
	width: 316px;
	position: absolute;
	display: block;
	visibility: hidden;
	padding: 0px;
	font: normal 12px  tahoma, sans-serif;
	top: 0px;
	margin: 0;
	left: 80px;
	z-index: 99999;
}
#suggestBlock {
	padding-top: 2px;
	padding-bottom: 2px;
	width: 100%;
	border: 0px;
}
#suggestBlock td {
	padding-left: 2px;
}
#suggestBlock tr {
	padding: 3px;
	padding-left: 8px;
	background: white;
}
#suggestBlock .suggestRowHighlight {
	background: #59a6ec;
	color: white;
	cursor: default;
}
#suggestBlock .cleft {
	padding-left: 5px;
}
#suggestBlock .cright {
	text-align: right;
	padding-right: 5px;
}
.suggestClose {
	display: block;
	text-align: right;
	font: normal 10px verdana, tahoma, sans-serif;
	background: #3394e6;
	padding: 5px;
	cursor: pointer;
}
</style>
<form method=post name=form action="{{ php_self }}?action=send">
<div class="card-body bg-white rounded">
	<h1 class="item-title-page">{{ lang['pm:pm'] }}</h1>
	<div class="row mb-4">
		<div class="col-4"><a class="bbcodes btn-block text-center bg-primary" href="{{ pm_inbox_link }}">{{ lang['pm:inbox'] }}</a></div>
		<div class="col-4"><a class="bbcodes btn-block text-center bg-primary" href="{{ pm_outbox_link }}">{{ lang['pm:outbox'] }}</a></div>
		<div class="col-4"><a class="bbcodes btn-block text-center bg-primary" href="{{ pm_set_link }}">{{ lang['pm:set'] }}</a></div>
	</div>
	<div class="form-group">
		<input placeholder="{{ lang['pm:too'] }}" type="text" name="to_username" id="to_username" maxlength="70" autocomplete="off" value="{{ username }}" required>
	</div>
	<div class="form-group">
		<input placeholder="{{ lang['pm:subject'] }}" type="text" name="title" required>
	</div>
	<div class="form-group">
		<div class="bb-editor">{{ quicktags }}<textarea onkeypress="if(event.keyCode==10 || (event.ctrlKey && event.keyCode==13)) {add_comment();}" name="content" id="pm_content"></textarea></div>
		<br /><input name="saveoutbox" type="checkbox"/> {{ lang['pm:saveoutbox'] }}
	</div>
	<div class="form_submit mt-3">
		<button class="bbcodes bg-primary" type="submit"><b>{{ lang['pm:send'] }}</b></button>
	</div>
</div>
</form>
<script language="javascript" type="text/javascript">
	function systemInit() {
		new ngSuggest('to_username',
			{
				'iMinLen' : 1,
				'stCols' : 1,
				'stColsClass': ['cleft'],
				'lId' : 'suggestLoader',
				'hlr' : 'true',
				'stColsHLR'	: [ true ],
				'reqMethodName' : 'pm_get_username',
			}
		);
	}
	if (document.body.attachEvent) {
		document.body.onload = systemInit;
	} else {
		systemInit();
	}
</script>