<form action="{{ form_url }}" method="get">
	<div class="card-body bg-white rounded mb-4">
		<h1 class="item-title-page">{{ lang['search.site_search'] }}</h1>
		<div class="row">
			<div class="col-md-6">
				<div class="form-group">
					<label>{{ lang['search.title'] }}</label>
					<input type=text name="search" value="{{ search }}" />
				</div>
				<div class="form-group">
					<label>{{ lang['search.filter.category'] }}</label>
					<div>{{ catlist }}</div>
				</div>
			</div>
			<div class="col-md-6">
				<div class="form-group">
					<label>{{ lang['search.filter.author'] }}</label>
					<input type="text" name="author" value="{{ author }}" />
				</div>
				<div class="form-group">
					<label>{{ lang['search.filter.date'] }}</label>
					<select name="postdate">
						<option value=""></option>
						{{ datelist }}
					</select>
				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-lg-12">
				<button class="btn btn-primary btn-block" type="submit">{{ lang['search.submit'] }}</button>
			</div>
		</div>
	</div>
</form>
{% if (flags.found) %}
	<div class="alert alert-danger mb-4">
		{{ lang['search.found'] }}: <b>{{ count }}</b>
	</div>
{% endif %}
{% if (flags.notfound) %}
	<div class="alert alert-danger mb-4">
		{{ lang['search.notfound'] }}
	</div>
{% endif %}
{% if (flags.error) %}
	<div class="alert alert-danger mb-4">
		{{ lang['search.error'] }}
	</div>
{% endif %}
{{ entries }}