{% if (global.flags.isLogged) %}
	<button class="dropdown-toggle" type="button" data-toggle="dropdown" aria-expanded="false">
		<span class="media">
			<span class="item-img">
				<img src="{{ avatar_url }}" width="44px" alt="Chat">
				<span class="acc-verified"><i class="icofont-check"></i></span>
			</span>
			<span class="media-body"><span class="item-title">{{ global.user.name }}</span></span>
		</span>
	</button>
	<div class="dropdown-menu dropdown-menu-right">
		<ul class="admin-options">
			{% if (global.flags.isLogged and (global.user['status'] <= 3)) %}
				<li><a href="{{ admin_url }}" target="_blank">{{ lang.admin_panel }}</a></li>
			{% endif %}
			{% if pluginIsActive('nsm') %}
				<li><a href="{{ p.nsm.link }}">{{ lang.add_news }}</a></li>
			{% endif %}
			{% if pluginIsActive('uprofile') %}
				<li><a href="{{ user_link }}">{{ lang.myprofile }}</a></li>
				<li><a href="{{ profile_link }}">{{ lang.edit_profile }}</a></li>
			{% endif %}
			{% if pluginIsActive('pm') %}
				<li><a href="{{ p.pm.link }}">{{ lang.private_messages }} <span class="pull-right">{{ p.pm.pm_unread }} / {{ p.pm.pm_all }}</span></a></li>
			{% endif %}
			{% if pluginIsActive('bookmarks') %}
				<li><a href="{{ p.bookmarks.link }}">{{ lang.theme.p_bookmarks }} <span class="pull-right">{{ p.bookmarks.count }}</span></a></li>
			{% endif %}
			<li><a href="{{ logout_link }}">{{ lang.log_out }}</a></li>
		</ul>
	</div>
{% else %}
	<script language="javascript">
		var set_login = 0;
		var set_pass  = 0;
	</script>
	<button class="dropdown-toggle" type="button" data-toggle="dropdown" aria-expanded="false">
		<span class="media">
			<span class="item-img"><img src="{{ tpl_url }}/images/noavatar.png" width="44px" alt="img"></span>
			<span class="media-body"><span class="item-title">{{ lang.login }}</span></span>
		</span>
	</button>
	<div class="dropdown-menu dropdown-menu-right" style="min-width:300px">
		<form class="p-3" name="login" method="post" action="{{ form_action }}" id="login">
			<div class="form-group">
				<label for="user_login">{{ lang.username }}</label>
				<input type="text" name="username" value="">
			</div>
			<div class="form-group">
				<label for="user_pass">{{ lang.password }}</label>
				<input type="password" name="password">
			</div>
			<div class="form-group mb-2">
				<div class="admin_checkboxs">
					<input type="checkbox" name="login_not_save" id="login_save" value="1"/>
					<label for="login_save" style="font-weight:400">{{ lang.remember_me }}</label> 
				</div>
			</div>
			<input type="submit" class="btn btn-primary mb-2 btn-block" value="{{ lang.login }}">
			<input type="hidden" name="redirect" value="{{ redirect }}" />
			<a href="{{ reg_link }}" class="btn btn-light btn-block">{{ lang.registration }}</a>
			<a href="{{ lost_link }}" class="btn btn-light btn-block">{{ lang.lostpassword }}</a>
		</form>
	</div>
{% endif %}