<!DOCTYPE html>
<!--[TWIG]-->
<html lang="{{ lang['langcode'] }}">
	<head>
		<meta http-equiv="content-type" content="text/html; charset={{ lang['encoding'] }}" />
		<meta http-equiv="content-language" content="{{ lang['langcode'] }}" />
		<meta name="generator" content="{{ what }} {{ version }}" />
		<meta name="document-state" content="dynamic" />
		<meta http-equiv="imagetoolbar" content="no" />
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
		{{ htmlvars }}
		<link rel="stylesheet" href="{{ tpl_url }}/css/bootstrap.css">
		<link rel="stylesheet" href="{{ tpl_url }}/css/font-awesome.min.css">
		<link rel="stylesheet" href="{{ tpl_url }}/css/ech.css">
		<link rel="stylesheet" href="{{ tpl_url }}/css/jquery.fancybox.min.css">
		<link rel="stylesheet" href="{{ tpl_url }}/css/engine.css">
		{% if pluginIsActive('rss_export') %}<link href="{{ home }}/rss.xml" rel="alternate" type="application/rss+xml" title="RSS" />{% endif %}
		<script type="text/javascript" src="{{ scriptLibrary }}/functions.js"></script>
		<script type="text/javascript" src="{{ scriptLibrary }}/ajax.js"></script>
		<title>{{ titles }}</title>
	</head>
	<body class="d-flex flex-column h-100">
		{% block body %}
			{% include "includes/menu.tpl" %}
			<div class="container my-4 flex-shrink-0">
				<div class="row">
					<div class="col-12 col-lg-9">
						{% if isHandler('news:main') %}
							{% include "includes/info.tpl" %}
						{% endif %}
						{% if isHandler('news:main') %}
							<div class='row row-flex'>
								{{ mainblock }}
							</div>
						{% else %}
							{{ mainblock }}
						{% endif %}
					</div>
					<div class="col-12 col-lg-3 d-none d-lg-inline-block"> 
						{% include "includes/sidebar.tpl" %}
					</div>            
				</div>
			</div> 
			{% include "includes/footer.tpl" %}
			<script type="text/javascript" src="{{ tpl_url }}/js/jquery.js"></script>
			<script type="text/javascript" src="{{ tpl_url }}/js/jqueryui.js"></script>
			<div id="loading-layer">{{ lang.theme.main_loading }}</div>
			<script src="{{ tpl_url }}/js/jquery.fancybox.min.js"></script>
			<script src="{{ tpl_url }}/js/bootstrap.min.js"></script>
			<script src="{{ tpl_url }}/js/lib.js"></script>
		{% endblock %}
	</body>
</html>
<!--[/TWIG]-->