[TWIG]
<div class="card mb-5">
	<div class="card-body">
		<div class="dropdown float-right">
			{% if (global.flags.isLogged) %}
				<button class="text-black-50 btn btn-sm btn-light dropdown-toggle pt-1 mr-3" type="button" id="dropdownMenu2" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
					<i class="fa fa-angle-down" aria-hidden="true"></i>
				</button>
				<div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenu2" style="font-size: 90%;">
					{% if pluginIsActive('bookmarks') %}{{ plugin_bookmarks_news }}{% endif %}
					{% if (news.flags.canEdit) %}<a href="{{ news.url.edit }}" class="dropdown-item">{{ lang.editnews }}</a>{% endif %}
				</div>
			{% endif %}
			<div class="rate_like-dislike">
				<a href="#"><span class="rpluse" title="{{ lang.theme.news_rpluse }}"><i class="fa fa-thumbs-o-up"></i> 0</span></a>
				<a href="#"><span class="rminus" title="{{ lang.theme.news_rminus }}"><i class="fa fa-thumbs-o-down"></i> 0</span></a>
			</div>
		</div>
		<h6 class="text-dark1 mb-0">{% if (news.flags.isPinned) %}<span class="badge badge-warning"><i class="fa fa-angle-double-up" aria-hidden="true"></i></span>{% endif %} {{ news.title }}</h6>
		<hr>
		{{ news.short }}{{ news.full }}

		<div class="card-footer px-0 mt-3" id="files">
			<h5 class="card-title">{{ lang.theme.news_files }}</h5>
			<div class="row px-3">
				{% for file in _files %}
					<div class="col-md-4 p-1">
						<a class="btn btn-primary btn-sm btn-block" href="{{ file.url }}"><b>{{ file.origName }}</b></a>
					</div>
				{% endfor %}
			</div>
		</div>
		
		{% if (news.flags.hasPagination) %}
			<ul class="pagination" style="width: auto;">
				<li class="hidden-xs">{{ news.pagination }}</li>
			</ul>
		{% endif %}
		{% if (news.flags.isUpdated) %}<p class="editdate grey"></p>
			<div class="alert alert-warning mb-0 mt-3 p-2 pl-3 pr-3 f90" role="alert">
				{{ lang['updated'] }} {{ news.update }}
			</div>
		{% endif %}
	</div>     
	<div style="border: 1px solid #eee;margin-left: 20px;margin-right: 20px;" class="p-3 text-muted f90">
		<span class="masha_index masha_index9" rel="9"></span>
		<span class="masha_index masha_index6" rel="6"></span>
		<span class="masha_index masha_index4" rel="4"></span>
		{{ lang.theme.news_text }}
	</div>   
	<div class="card-footer">
		<div class="row">
			<div class="col-6 col-sm-6 col-md-4 col-lg-3 mb-3 mb-md-3 mb-lg-0">
				<div class="media">
					<svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="currentColor" class="bi bi-person align-self-center mr-2" viewBox="0 0 16 16">
						<path d="M8 8a3 3 0 1 0 0-6 3 3 0 0 0 0 6zm2-3a2 2 0 1 1-4 0 2 2 0 0 1 4 0zm4 8c0 1-1 1-1 1H3s-1 0-1-1 1-4 6-4 6 3 6 4zm-1-.004c-.001-.246-.154-.986-.832-1.664C11.516 10.68 10.289 10 8 10c-2.29 0-3.516.68-4.168 1.332-.678.678-.83 1.418-.832 1.664h10z"></path>
					</svg>
					<div class="media-body">
						<div class="m-0 ttle">{% if pluginIsActive('uprofile') %}<a href="{{ news.author.url }}">{% endif %}{{ news.author.name }}{% if pluginIsActive('uprofile') %}</a>{% endif %}</div>
						<div class="f90 text-muted">{{ lang.theme.news_author }}</div>
					</div>
				</div>
			</div>
			<div class="col-6 col-sm-6 col-md-4 col-lg-3 mb-3 mb-md-3 mb-lg-0">
				<div class="media">
					<svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" fill="currentColor" class="bi bi-clock align-self-center mr-2" viewBox="0 0 16 16">
						<path d="M8 3.5a.5.5 0 0 0-1 0V9a.5.5 0 0 0 .252.434l3.5 2a.5.5 0 0 0 .496-.868L8 8.71V3.5z"></path>
						<path d="M8 16A8 8 0 1 0 8 0a8 8 0 0 0 0 16zm7-8A7 7 0 1 1 1 8a7 7 0 0 1 14 0z"></path>
					</svg>
					<div class="media-body">
						<div class="m-0 ttle">{{ news.dateStamp|date("j.m.Y") }}</div>
						<div class="f90 text-muted">{{ lang.theme.news_date }}</div>
					</div>
				</div>
			</div>
			<div class="col-6 col-sm-6 col-md-4 col-lg-3 mb-3 mb-md-3 mb-lg-0">
				<div class="media">
					<svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" fill="currentColor" class="bi bi-stickies align-self-center mr-2" viewBox="0 0 16 16">
						<path d="M1.5 0A1.5 1.5 0 0 0 0 1.5V13a1 1 0 0 0 1 1V1.5a.5.5 0 0 1 .5-.5H14a1 1 0 0 0-1-1H1.5z"></path>
						<path d="M3.5 2A1.5 1.5 0 0 0 2 3.5v11A1.5 1.5 0 0 0 3.5 16h6.086a1.5 1.5 0 0 0 1.06-.44l4.915-4.914A1.5 1.5 0 0 0 16 9.586V3.5A1.5 1.5 0 0 0 14.5 2h-11zM3 3.5a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 .5.5V9h-4.5A1.5 1.5 0 0 0 9 10.5V15H3.5a.5.5 0 0 1-.5-.5v-11zm7 11.293V10.5a.5.5 0 0 1 .5-.5h4.293L10 14.793z"></path>
					</svg>
					<div class="media-body" style="display: grid;">
						<p class="m-0 shtitle text-truncate">{{ news.categories.text }}</p>
						<p class="m-0 text-muted" style="font-size: 85%;">{{ lang.theme.news_categorie }}</p>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
{% if pluginIsActive('comments') %}{{ plugin_comments }}{% endif %}
[/TWIG]