{% extends localPath(0) ~ "site.body.tpl" %}
{% block content %}
	{% if (flags.link_news) %}
		<div class="alert alert-info">
			<b>Запрос по новости : <a href="{{ news.url }}">{{ news.title }}</a></b>
		</div>
	{% endif %}
	{{ description }}<br/><br/>
	{% if (flags.jcheck) %}
		<script language="JavaScript">
			var FBF_INIT = {{ FBF_DATA }};
			function FBF_CHECK() {
				var frm = document.getElementById('feedback_form');
				if (frm == null) return true;

				var i;
				for (i in FBF_INIT) {
					if (FBF_INIT[i][1]) {
						if (FBF_INIT[i][0] == 'date') {
							if ((frm[i + ':day'].value == '1') && (frm[i + ':month'].value == '1') && (frm[i + ':year'].value == '1970')) {
								alert('{l_feedback:form.err.notfilled} (' + FBF_INIT[i][2] + ')!');
								frm[i + ':day'].focus();
								return false;
							}
						} else if (frm[i].value == '') {
							alert('{l_feedback:form.err.notfilled} (' + FBF_INIT[i][2] + ')!');
							frm[i].focus();
							return false;
						}
					}
				}
				return true;
			}
		</script>
	{% endif %}
	<form method="post" action="{{ form_url }}" id="feedback_form" name="feedback_form">
		{{ hidden_fields }}
		<input type="hidden" name="id" value="{{ id }}"/>
			{% for entry in entries %}
				{% if entry.type == 'text' %}
					<div class="form-group">
						<label>{{ entry.title }}</label>
						<input type="text" name="{{ entry.name }}" class="form-control" required>
					</div>
				{% endif %}
				{% if entry.type == 'email' %}
					<div class="form-group">
						<label>{{ entry.title }}</label>
						<input type="text" name="{{ entry.name }}" class="form-control" required>
					</div>
				{% endif %}
				{% if entry.type == 'textarea' %}
					<div class="form-group">
						<label>{{ entry.title }}</label>
						<textarea name="{{ entry.name }}" rows="8" class="form-control" required>{{ entry.value }}</textarea>
					</div>
				{% endif %}
				{% if entry.type == 'select' %}
					<div class="form-group">
						<label>{{ entry.title }}</label>
						<select name="{{ entry.name }}" class="form-control">{{ entry.options.select }}</select>
					</div>
				{% endif %}
				{% if entry.type == 'date' %}
					<div class="form-group">
						<label>{{ entry.title }}</label>
						<div><select name="{{ entry.name }}:day" style="width: 33%;display: inline;" class="form-control">{{ entry.options.day }}</select> <select name="{{ entry.name }}:month" style="width: 33%;display: inline;" class="form-control">{{ entry.options.month }}</select> <select name="{{ entry.name }}:year" style="width: 33%;display: inline;" class="form-control">{{ entry.options.year }}</select></div>
					</div>
				{% endif %}
			{% endfor %}
			{% if (flags.captcha) %}
				<div class="form-group">
					<div class="dle-captcha">
						<span><img id="img_captcha" onclick="this.src='{{ captcha_url }}&rand='+Math.random();" src="{{ captcha_url }}&rand={{ captcha_rand }}" style="background: #fff; cursor: pointer;" alt="Security code" /></span>
						<input placeholder="{{ lang.theme.code }}" title="{{ lang.theme.code_info }}" type="text" name="vcode" class="form-control" required>
					</div>
				</div>
			{% endif %}
			{% if (flags.recipients) %}
				<div class="form-group">
					<label>{{ lang['feedback:sform.elist'] }}</label>
					<select name="recipient" class="form-control">{{ recipients_list }}</select>
				</div>
			{% endif %}

		<div class="form_submit">
			<button {% if (flags.jcheck) %}onclick="return FBF_CHECK();" {% endif %}class="btn btn-success" type="submit">{{ lang.theme.send }}</button>
		</div>
	</form>
{% endblock %}