<script type="text/javascript">
	// Global variable: ID of current active input area
	{% if (flags.edit_split) %}var currentInputAreaID = 'ng_news_content_short';{% else %}var currentInputAreaID = 'ng_news_content';{% endif %}
	function preview(){
		var form = document.getElementById("postForm");
		if (form.ng_news_content{% if (flags.edit_split) %}_short{% endif %}.value == '' || form.title.value == '') {
			alert('{{ lang.nsm['err.preview'] }}');
			return false;
		}
		form['mod'].value = "preview";
		form.target = "_blank";
		form.submit();
		form['mod'].value = "news";
		form.target = "_self";
		return true;
	}
	function changeActive(name) {
		if (name == 'full') {
			document.getElementById('container.content.full').className  = 'contentActive';
			document.getElementById('container.content.short').className = 'contentInactive';
			currentInputAreaID = 'ng_news_content_full';
		} else {
			document.getElementById('container.content.short').className = 'contentActive';
			document.getElementById('container.content.full').className  = 'contentInactive';
			currentInputAreaID = 'ng_news_content_short';
		}
	}
	function approveMode(mode) {
		document.getElementById('approve').value = mode;
		return true;
	}
</script>
<form id="postForm" name="form" ENCTYPE="multipart/form-data" method="POST" action="{{ currentURL }}">
<input type="hidden" name="token" value="{{ token }}"/>
<input type="hidden" name="mod" value="news"/>
<input type="hidden" name="approve" id="approve" value="0"/>
<div class="col-md-12">
	<div class="card w-100">
		<div class="card-body">
			<div class="d-flex align-items-center justify-content-between">
				<div class="d-flex align-items-center">
					<h5 class="page_title mb-3">{{ lang.nsm['addnews_title'] }}</h5>
				</div>
				<div class="col-md-5">
					<a class="btn btn-primary btn-block" href="{{ listURL }}">{{ lang.nsm['news.list'] }}</a>
				</div>
			</div>
			<div class="row">
				<div class="col-md-6">
					<div class="form-group mb-3">
						<label>{{ lang.nsm['newstitle'] }}</label>
						<input type="text" name="title" value="" class="form-control" required>
					</div>
				</div>
				<div class="col-md-6">
					<div class="form-group mb-3">
						<label>{{ lang.nsm['alt_name'] }}</label>
						<input type="text" name="alt_name" value="" class="form-control" required>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-md-6">
					<div class="form-group mb-3">
						<label>{{ lang.nsm['category'] }}</label>
						<div class="form-control-s">{{ mastercat }}</div>
					</div>
				</div>
				{% if flags['multicat.show'] %}
					<div class="col-md-6">
						<div class="form-group mb-3">
							<label>{{ lang.nsm['dop.categories'] }}</label>
							<div style="overflow:auto;max-height:100px;margin-bottom:10px">
								{{ extcat }}
							</div>
						</div>
					</div>
				{% endif %}
			</div>
			{% if (flags.edit_split) %}
				<div class="col-md-12">
					<div class="form-group mb-3">
						<label>{{ lang.nsm['news.anons'] }}: ({{ lang.nsm['desk.news.anons'] }})</label>
						<div class="bb-editor">
							{{ quicktags }}
							<textarea onclick="changeActive('short');" onfocus="changeActive('short');" name="ng_news_content_short" id="ng_news_content_short" rows="5" class="form-control" required></textarea>
						</div>
					</div>
				</div>
				{% if (flags.extended_more) %} 
					<div class="col-md-12">
						<div class="form-group mb-3">
							<label>{{ lang.nsm['news.more'] }}</label>
							<input type="text" name="content_delimiter" value="" class="form-control" required>
						</div>
					</div>
				{% endif %}
				<div class="col-md-12">
					<div class="form-group mb-3">
						<label>{{ lang.nsm['full.news'] }}: ({{ lang.nsm['desk.news.full'] }})</label>
						<div class="bb-editor">
							{{ quicktags }}
							<textarea onclick="changeActive('full');" onfocus="changeActive('full');" name="ng_news_content_full" id="ng_news_content_full" rows="5" class="form-control" required></textarea>
						</div>
					</div>
				</div>
			{% else %}
				<div class="col-md-12">
					<div class="form-group mb-3">
						<div class="bb-editor">
							{{ quicktags }}
							<textarea name="ng_news_content" id="ng_news_content" rows="10" class="form-control" required></textarea>
						</div>
					</div>
				</div>
			{% endif %}
			<div class="form-group mb-3">
				<div class="custom-control custom-switch">
					{% if not flags['mainpage.disabled'] %}
						<div class="m-2">
							<input type="checkbox" class="custom-control-input" name="mainpage" value="1" id="mainpage" {% if (flags.mainpage) %}checked="checked" {% endif %}{% if flags['mainpage.disabled'] %}disabled {% endif %}  />
							<label class="custom-control-label" for="mainpage">{{ lang.nsm['mainpage'] }}</label>
						</div>
					{% endif %}
					{% if not flags['pinned.disabled'] %}
						<div class="m-2">
							<input type="checkbox" class="custom-control-input" name="pinned" value="1" id="pinned" {% if (flags.pinned) %}checked="checked" {% endif %}{% if flags['pinned.disabled'] %}disabled {% endif %} />
							<label class="custom-control-label" for="pinned">{{ lang.nsm['add_pinned'] }}</label>
						</div>
					{% endif %}
					{% if not flags['catpinned.disabled'] %}
						<div class="m-2">
							<input type="checkbox" class="custom-control-input" name="catpinned" value="1" id="catpinned" {% if (flags.catpinned) %}checked="checked" {% endif %}{% if flags['catpinned.disabled'] %}disabled {% endif %} />
							<label class="custom-control-label" for="catpinned">{{ lang.nsm['add_catpinned'] }}</label>
						</div>
					{% endif %}
					{% if not flags['favorite.disabled'] %}
						<div class="m-2">
							<input type="checkbox" class="custom-control-input" name="favorite" value="1" id="favorite" {% if (flags.favorite) %}checked="checked" {% endif %}{% if flags['favorite.disabled'] %}disabled {% endif %} />
							<label class="custom-control-label" for="favorite">{{ lang.nsm['add_favorite'] }}</label>
						</div>
					{% endif %}
					{% if not flags['html.disabled'] %}
						<div class="m-2">
							<input type="checkbox" class="custom-control-input" name="flag_HTML" value="1" id="flag_HTML" {% if (flags['html.disabled']) %}disabled {% endif %}{% if flags['html'] %}checked="checked"{% endif %} />
							<label class="custom-control-label" for="flag_HTML">{{ lang.nsm['flag_html'] }}</label>
						</div>
						<div class="m-2">
							<input type="checkbox" class="custom-control-input" name="flag_RAW" value="1" id="flag_RAW" {% if (flags['html.disabled']) %}disabled {% endif %}{% if flags['html'] %}checked="checked"{% endif %} />
							<label class="custom-control-label" for="flag_RAW">{{ lang.nsm['flag_raw'] }}</label>
						</div>
					{% endif %}
				</div>
			</div>
			<div class="form_submit">
				{% if flags['can_publish'] %}
					<button class="btn btn-outline-success" onclick="return approveMode(1);" type="submit"><b>{{ lang.nsm['add'] }}</b></button>
				{% else %} &nbsp; {% endif %}
				<button class="btn btn-outline-warning" onclick="return approveMode(0);" type="submit"><b>{{ lang.nsm['moder.news'] }}</b></button>
				<button class="btn btn-outline-dark" onclick="return approveMode(-1);" type="submit"><b>{{ lang.nsm['save.draft'] }}</b></button>
				<button class="btn btn-outline-info" onclick="return preview();" otype="button"><b>{{ lang.nsm['preview'] }}</b></button>
			</div>
		</div>
	</div>
</div>
</form>
<script language="javascript" type="text/javascript">
	// Restore variables if needed
	var jev = {{ JEV }};
	var form = document.getElementById('postForm');
	for (i in jev) {
		//try { alert(i+' ('+form[i].type+')'); } catch (err) {;}
		if (typeof(jev[i]) == 'object') {
			for (j in jev[i]) {
				//alert(i+'['+j+'] = '+ jev[i][j]);
				try { form[i+'['+j+']'].value = jev[i][j]; } catch (err) {;}
			}
		} else {
			try {
				if ((form[i].type == 'text')||(form[i].type == 'textarea')||(form[i].type == 'select-one')) {
					form[i].value = jev[i];
				} else if (form[i].type == 'checkbox') {
					form[i].checked = (jev[i]?true:false);
				}
			} catch(err) {;}
		}
	}
</script>