<div class="col-md-12">
	<div class="card w-100">
		<div class="card-body">
			<div class="d-flex align-items-center justify-content-between">
				<div class="d-flex align-items-center">
					<h5 class="page_title mb-3">{{ lang.nsm['list.news'] }}</h5>
				</div>
				<div class="col-md-3">
					<a class="btn btn-primary btn-block" href="{{ addURL }}">{{ lang.nsm['add.news'] }}</a>
				</div>
			</div>
			<table class="nsm">
				<tr align="center">
					<td width="40">{{ lang.nsm['status.news'] }}</td>
					<td width="60">{{ lang.nsm['data.news.published'] }}</td>
					<td>&nbsp;</td>
					<td>{{ lang.nsm['add.news.title'] }}</td>
				</tr>
				{% for entry in entries %}
					<tr>
						<td width="25" align="center">
							{% if (entry.state == 1) %}
								<i class="fa fa-check" style="color:#6BA54A;" title="{{ lang.nsm['state.published'] }}"></i>
							{% elseif (entry.state == 0) %}
								<i class="fa fa-times" style="color:#CE0000;" title="{{ lang.nsm['state.unpublished'] }}"></i>
							{% else %}
								<i class="fa fa-book" style="color:#424242;" title="{{ lang.nsm['state.draft'] }}"></i>
							{% endif %}
						</td>
						<td width="60">{% if entry.flags.canEdit %}<a href="{{ entry.editlink }}">{% endif %}{{ entry.itemdate }}{% if entry.flags.canView %}</a>{% endif %}</td>
						<td width="68" cellspacing=0 cellpadding=0 align="center">
							{% if entry.flags.mainpage %}
								<i class="fa fa-home" style="color:#000000;" title="{{ lang.nsm['entry.main'] }}"></i>
							{% endif %}
							{% if (entry.attach_count > 0) %}
								<i class="fa fa-paperclip" style="color:#3984C6;" title="{{ lang.nsm['entry.files'] }}: {{ entry.attach_count }}"></i>
							{% endif %}
							{% if (entry.images_count > 0) %}
								<i class="fa fa-picture-o" style="color:#EFC631;" title="{{ lang.nsm['entry.img'] }}: {{ entry.images_count }}"></i>
							{% endif %}
						</td>
						<td>
							{% if entry.flags.status %}<a href="{{ entry.link }}">{% endif %}
								{{ entry.title }}
							{% if entry.flags.status %}</a>{% endif %} 
							{% if entry.flags.canEdit %}
								<a href="{{ entry.editlink }}"><i class="fa fa-cog"></i></a>
							{% endif %}
						</td>
					</tr>
				{% else %}
					<tr>
						<td colspan="4">{{ lang.nsm['err.news_not'] }}</td>
					</tr>
				{% endfor %}
			</table>
		</div>
	</div>
</div>
{% if pagination %}
	<div class="mt-3" style="width: 100%;display: -webkit-box;">
		<ul class="pagination" style="width: auto;">
			<li class="hidden-xs">{{ pagination }}</li>
		</ul>
	</div>
{% endif %}