<div class="card mb-3">
	<div class="card-body">
		<h5 class="card-title">{{ lang['pm:pm'] }}</h5>
		<div class="row">
			<div class="col-md-6">
				<ul class="list-inline">
					<li class="list-inline-item"><a class="btn btn-sm btn-secondary" href="{{ pm_inbox_link }}">{{ lang['pm:inbox'] }}</a></li>
					<li class="list-inline-item"><a class="btn btn-sm btn-secondary" href="{{ pm_outbox_link }}">{{ lang['pm:outbox'] }}</a></li>
					<li class="list-inline-item"><a class="btn btn-sm btn-secondary" href="{{ pm_set_link }}">{{ lang['pm:set'] }}</a></li>
				</ul>
			</div>
			<div class="col-md-6">
				{% if max_messages > 0 %}
					<ul class="list-unstyled m-0">
						<li>{{ lang.theme.pm_current_messages }}: <b>{{ current_messages }}%</b>  <small>({{ current_messages }} / {{ max_messages }} {{ lang.theme.pm_max_messages }})</small></li>
						<li>
							<div class="pm_progress_bar" title="{{ lang.theme.pm_current_messages }}: {{ current_messages }}%"><span style="width: {{ current_messages }}%">{{ current_messages }}%</span></div>
						</li>
					</ul>
				{% endif %}
			</div>
		</div>
		<form name="form" method="POST" action="{{ php_self }}?action=delete" style="display: inline;">
			<table width="100%" class="pm">
				<tr align="center">
					<td width="25%" class="pm_head">{{ lang['pm:date'] }}</td>
					<td width="40%" class="pm_head">{{ lang['pm:subject'] }}</td>
					<td width="30%" class="pm_head">{{ lang['pm:too'] }}</td>
					<td width="5%" class="pm_head"><input type="checkbox" name="master_box" title="{{ lang['pm:checkall'] }}" onclick="javascript:check_uncheck_all(form)"></td>
				</tr>
				{% for entry in entries %}
					<tr align="center">
						<td class="pm_list">{{ entry.pmdate|date('Y-m-d H:i') }}</td>
						<td class="pm_list"><a href="{{ php_self }}?action=read&pmid={{ entry.pmid }}&location=outbox">{{ entry.subject }}</a></td>
						<td class="pm_list">{{ entry.link }}</td>
						<td class="pm_list"><input name="selected_pm[]" value="{{ entry.pmid }}" type="checkbox"/></td>
					</tr>
				{% endfor %}
			</table>
			<button class="btn btn-danger mt-1" type="submit">{{ lang['pm:delete'] }}</button>
		</form>
		<form name="pm" method="POST" action="{{ php_self }}?action=write" style="display: inline;">
			<button class="btn btn-primary mt-1" type="submit">{{ lang['pm:write'] }}</button>
		</form>
	</div>
</div>
{% if pagination %}
	<div class="mt-3" style="width: 100%;display: -webkit-box;">
		<ul class="pagination" style="width: auto;">
			<li class="hidden-xs">{{ pagination }}</li>
		</ul>
	</div>
{% endif %}