<script type="text/javascript" src="{{ scriptLibrary }}/libsuggest.js"></script>
<style>
.suggestWindow {
	background: #ffffff;
	border: 1px solid #3394e6;
	width: 316px;
	position: absolute;
	display: block;
	visibility: hidden;
	padding: 0px;
	font: normal 12px  tahoma, sans-serif;
	top: 0px;
	margin: 0;
	left: 80px;
	z-index: 99999;
}
#suggestBlock {
	padding-top: 2px;
	padding-bottom: 2px;
	width: 100%;
	border: 0px;
}
#suggestBlock td {
	padding-left: 2px;
}
#suggestBlock tr {
	padding: 3px;
	padding-left: 8px;
	background: white;
}
#suggestBlock .suggestRowHighlight {
	background: #59a6ec;
	color: white;
	cursor: default;
}
#suggestBlock .cleft {
	padding-left: 5px;
}
#suggestBlock .cright {
	text-align: right;
	padding-right: 5px;
}
.suggestClose {
	display: block;
	text-align: right;
	font: normal 10px verdana, tahoma, sans-serif;
	background: #3394e6;
	padding: 5px;
	cursor: pointer;
}
</style>
<div class="card mb-3">
	<div class="card-body">
		<h5 class="card-title">{{ lang['pm:pm'] }}</h5>
		<div class="row">
			<div class="col-md-6">
				<ul class="list-inline">
					<li class="list-inline-item"><a class="btn btn-sm btn-secondary" href="{{ pm_inbox_link }}">{{ lang['pm:inbox'] }}</a></li>
					<li class="list-inline-item"><a class="btn btn-sm btn-secondary" href="{{ pm_outbox_link }}">{{ lang['pm:outbox'] }}</a></li>
					<li class="list-inline-item"><a class="btn btn-sm btn-secondary" href="{{ pm_set_link }}">{{ lang['pm:set'] }}</a></li>
				</ul>
			</div>
		</div>
		<form method=post name=form action="{{ php_self }}?action=send">
			<div class="row">
				<div class="col-md-6">
					<div class="form-group mb-3">
						<label>{{ lang['pm:too'] }}</label>
						<input type="text" name="to_username" id="to_username" maxlength="70" autocomplete="off" value="{{ username }}" class="form-control" required>
					</div>
				</div>
				<div class="col-md-6">
					<div class="form-group mb-3">
						<label>{{ lang['pm:subject'] }}</label>
						<input ptype="text" name="title" class="form-control" required>
					</div>
				</div>
				<div class="col-md-12">
					<div class="form-group mb-3">
						<div class="bb-editor">{{ quicktags }}<textarea onkeypress="if(event.keyCode==10 || (event.ctrlKey && event.keyCode==13)) {add_comment();}" name="content" id="pm_content" rows="5"></textarea></div>
					</div>
					<div class="custom-control custom-switch mt-3 mb-3">
						<input type="checkbox" class="custom-control-input" id="saveoutbox" name="saveoutbox" value="1">
						<label class="custom-control-label" for="saveoutbox">{{ lang['pm:saveoutbox'] }}</label>
					</div>
				</div>
			</div>
			<button class="btn btn-primary mt-1" type="submit">{{ lang['pm:send'] }}</button>
		</form>
	</div>
</div>
<script language="javascript" type="text/javascript">
	function systemInit() {
		new ngSuggest('to_username',
			{
				'iMinLen' : 1,
				'stCols' : 1,
				'stColsClass': ['cleft'],
				'lId' : 'suggestLoader',
				'hlr' : 'true',
				'stColsHLR'	: [ true ],
				'reqMethodName' : 'pm_get_username',
			}
		);
	}
	if (document.body.attachEvent) {
		document.body.onload = systemInit;
	} else {
		systemInit();
	}
</script>