<script type="text/javascript">

    $( document ).ready(function() {
        var registrationValidator = (function() {

            var validateFields = function() {

                $("#reg_login").change(function() {

                    if ($('#reg_login').val() == '') {
                        $("#reg_login").css({
                            "display": "table-cell",
                            "background": "#f9f9f9",
                            "border": "1px solid #e2e2e2",
                            "box-shadow": "inset 2px 3px 3px -2px #e2e2e2"
                        });
                        $("div#reg_login").html("<span>{{ lang.auth_login_descr }}</span>");
                        return;
                    }

                    $.post('/engine/rpc.php', { json : 1, methodName : 'core.registration.checkParams', rndval: new Date().getTime(), params : json_encode({ 'login' : $('#reg_login').val() }), dataType: 'json' }, function(data) {
                        if(typeof data == 'string') {
                            resTX = $.parseJSON(data);
                        } else {
                            resTX = data;
                        }
                        if (!resTX['status']) {
                            alert('Error ['+resTX['errorCode']+']: '+resTX['errorText']);
                        } else {
                            if ((resTX['data']['login']>0)&&(resTX['data']['login'] < 100)) {
                                $("#reg_login").css("border-color", "#b54d4b");
                                $("div#reg_login").html("<span style='color:#b54d4b;'>{{ lang.theme.registration_msg_login_warning }}</span>");
                            } else {
                                $("#reg_login").css("border-color", "#94c37a");
                                $("div#reg_login").html("<span style='color:#94c37a;'>{{ lang.theme.registration_msg_login_success }}</span>");
                            }
                        }
                    }, "text").error(function() {
                        alert('HTTP error during request', 'ERROR');
                    });

                });

                $("#reg_email").change(function() {

                    if ($('#reg_email').val() == '') {
                        $("#reg_email").css({
                            "display": "table-cell",
                            "background": "#f9f9f9",
                            "border": "1px solid #e2e2e2",
                            "box-shadow": "inset 2px 3px 3px -2px #e2e2e2"
                        });
                        $("div#reg_email").html("<span>{{ lang.auth_email_descr }}</span>");
                        return;
                    }

                    $.post('/engine/rpc.php', { json : 1, methodName : 'core.registration.checkParams', rndval: new Date().getTime(), params : json_encode({ 'email' : $('#reg_email').val() }), dataType: 'json' }, function(data) {
                        if(typeof data == 'string') {
                            resTX = $.parseJSON(data);
                        } else {
                            resTX = data;
                        }
                        if (!resTX['status']) {
                            alert('Error ['+resTX['errorCode']+']: '+resTX['errorText']);
                        } else {
                            if ((resTX['data']['email']>0)&&(resTX['data']['email'] < 100)) {
                                $("#reg_email").css("border-color", "#b54d4b");
                                $("div#reg_email").html("<span style='color:#b54d4b;'>{{ lang.theme.registration_msg_email_warning }}</span>");
                            } else {
                                $("#reg_email").css("border-color", "#94c37a");
                                $("div#reg_email").html("<span style='color:#94c37a;'>{{ lang.theme.registration_msg_email_success }}</span>");
                            }
                        }
                    }).error(function() {
                        alert('HTTP error during request', 'ERROR');
                    });

                });


                $("#reg_password2").change(function() {

                    if ($('#reg_password2').val() == '' && $('#reg_password').val() == '') {
                        $("#reg_password").css({
                            "display": "table-cell",
                            "background": "#f9f9f9",
                            "border": "1px solid #e2e2e2",
                            "box-shadow": "inset 2px 3px 3px -2px #e2e2e2"
                        });
                        $("#reg_password2").css({
                            "display": "table-cell",
                            "background": "#f9f9f9",
                            "border": "1px solid #e2e2e2",
                            "box-shadow": "inset 2px 3px 3px -2px #e2e2e2"
                        });
                        $("div#reg_password2").html("<span>{{ lang.auth_pass2_descr }}</span>");
                        return;
                    }

                    if ($('#reg_password2').val() != $('#reg_password').val()) {
                        $("#reg_password").css("border-color", "#b54d4b");
                        $("#reg_password2").css("border-color", "#b54d4b");
                        $("div#reg_password2").html("<span style='color:#b54d4b;'>{{ lang.theme.registration_msg_password_warning }}</span>");
                    } else {
                        $("#reg_password").css("border-color", "#94c37a");
                        $("#reg_password2").css("border-color", "#94c37a");
                        $("div#reg_password2").html("<span style='color:#94c37a;'>{{ lang.theme.registration_msg_password_success }}</span>");
                    }


                });


                $("#reg_password").change(function() {

                    if ($('#reg_password2').val() == '' && $('#reg_password').val() == '') {
                        $("#reg_password").css({
                            "display": "table-cell",
                            "background": "#f9f9f9",
                            "border": "1px solid #e2e2e2",
                            "box-shadow": "inset 2px 3px 3px -2px #e2e2e2"
                        });
                        $("#reg_password2").css({
                            "display": "table-cell",
                            "background": "#f9f9f9",
                            "border": "1px solid #e2e2e2",
                            "box-shadow": "inset 2px 3px 3px -2px #e2e2e2"
                        });
                        $("div#reg_password2").html("<span>{{ lang.auth_pass2_descr }}</span>");
                        return;
                    }
                    if ($('#reg_password2').val() != $('#reg_password').val()) {
                        $("#reg_password").css("border-color", "#b54d4b");
                        $("#reg_password2").css("border-color", "#b54d4b");
                        $("div#reg_password2").html("<span style='color:#b54d4b;'>{{ lang.theme.registration_msg_password_warning }}</span>");
                    } else {
                        $("#reg_password").css("border-color", "#94c37a");
                        $("#reg_password2").css("border-color", "#94c37a");
                        $("div#reg_password2").html("<span style='color:#94c37a;'>{{ lang.theme.registration_msg_password_success }}</span>");
                    }


                });

            };

            return {
                validateFields: validateFields
            };

        })();

        registrationValidator.validateFields();
    });

</script>
<form name="register" action="{{ form_action }}" method="post" onsubmit="return validate();">
<input type="hidden" name="type" value="doregister" />
<div class="card mb-3">
	<div class="card-body">
		<h5 class="card-title">{{ lang.registration }}</h5>
		<p class="card-text">
			{{ lang.theme.registration_descr }}
		</p>
		<hr/>
		{% for entry in entries %}
			{% if entry.type == 'input' %}
				<div class="form-group mb-3">
					<label>{{ entry.title }}</label>
					<input id="{{ entry.id }}" type="{{ entry.type }}" name="{{ entry.name }}" value="{{ entry.value }}" class="form-control" required>
					<div id="{{entry.id}}">{{ entry.descr }}</div>
				</div>
			{% endif %}
			{% if entry.type == 'password' %}
				<div class="form-group mb-3">
					<label>{{ entry.title }}</label>
					<input id="{{ entry.id }}" type="{{ entry.type }}" name="{{ entry.name }}" value="{{ entry.value }}" class="form-control" required>
					<div id="{{entry.id}}">{{ entry.descr }}</div>
				</div>
			{% endif %}
			{% if entry.type == 'text' %}
				<div class="form-group mb-3">
					<label>{{ entry.title }}</label>
					<textarea name="{{ entry.name }}" rows="5" class="form-control"></textarea>
				</div>
			{% endif %}
			{% if entry.type == 'select' %}
				<div class="form-group mb-3">
					<label>{{ entry.title }}</label>
					<select type="{{ entry.type }}" name="{{ entry.name }}" class="form-control">{% for key,value in entry.values %}<option value="{{ key }}">{{ value }}</option>{% endfor %}</select>
				</div>
			{% endif %}
		{% endfor %}
		{% if flags.hasCaptcha %}
			<div class="form-group mb-3">
				<span><img src="{{ admin_url }}/captcha.php?id=registration&force=1&rand={{ random() }}" onclick="reload_captcha();" id="img_captcha" style="background: #fff; cursor: pointer;" alt="Security code" width="120" height="40" /></span>
				<input placeholder="{{ lang.theme.code }}" title="{{ lang.theme.code_info }}" type="text" name="vcode" class="form-control" style="width:120px" required>
			</div>
		{% endif %}
		<div class="form-group mb-3">
			<input type="checkbox" name="agree"> <label>{{ lang.theme.registration_rules }}</label>
		</div>
	</div>
</div>
<div class="form_submit">
   <button class="btn btn-success" type="submit">{{ lang.register }}</button>
</div>
</form>
<script type="text/javascript">
	function validate() {
		if (document.register.agree.checked == false) {
			window.alert('{{ lang.theme.registration_check_rules }}');
			return false;
		}
		return true;
	}
	var ADMIN_URL = "{{ admin_url }}";
	function reload_captcha() {
		let img = document.getElementById('img_captcha');
		if (img) {
			img.src = ADMIN_URL + '/captcha.php?id=registration&force=1&rand=' + Math.random();
		}
	}
</script>