{% if (global.flags.isLogged) %}
	<li class="nav-item dropdown drp active">
		<a class="nav-link p-2 p-md-4" href="#" id="login_menu" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
			<div class="d-flex align-items-center">
				<img width="18" height="18" src="{{ avatar_url }}"class="profoto mr-2">{{ global.user.name }}
			</div>
		</a>
		<div class="dropdown-menu dropdown-menu-right" aria-labelledby="login_menu">
			{% if (global.flags.isLogged and (global.user['status'] <= 3)) %}
				<a class="dropdown-item dfx" target="_blank" href="{{ admin_url }}">
					<div class="ecn">
						<i class="fa fa-sliders"></i>
					</div>
					<div class="mr-4">{{ lang.admin_panel }}</div>
				</a>
			{% endif %}
			{% if pluginIsActive('nsm') %}
				<a class="dropdown-item dfx" href="{{ p.nsm.link }}">
					<div class="ecn">
						<i class="fa fa-plus-circle"></i>
					</div>
					<div class="mr-4">{{ lang.add_news }}</div>
				</a>
			{% endif %}
			{% if pluginIsActive('uprofile') %}
				<a class="dropdown-item dfx" href="{{ user_link }}">
					<div class="ecn">
						<i class="fa fa-user"></i>
					</div>
					<div class="mr-4">{{ lang.myprofile }}</div>
				</a>
				<a class="dropdown-item dfx" href="{{ profile_link }}">
					<div class="ecn">
						<i class="fa fa-cog"></i>
					</div>
					<div class="mr-4">{{ lang.edit_profile }}</div>
				</a>
			{% endif %}
			{% if pluginIsActive('pm') %}
				<a class="dropdown-item dfx" href="{{ p.pm.link }}">
					<div class="ecn">
						<i class="fa fa-envelope-o"></i>
					</div>
					<div class="mr-4">{{ lang.private_messages }}</div>
					<div style="color: #FFA500; text-decoration: none" class="ml-auto f80">{{ p.pm.pm_unread }} - {{ p.pm.pm_all }} </div>
				</a>
			{% endif %}
			{% if pluginIsActive('bookmarks') %}
				<a class="dropdown-item dfx" href="{{ p.bookmarks.link }}">
					<div class="ecn">
						<i class="fa fa-star-o"></i>
					</div>
					<div class="mr-4">{{ lang.theme.usermenu_bookmarks_link }}</div>
					<div style="color: #FFA500; text-decoration: none" class="ml-auto f80">{{ p.bookmarks.count }}</div>
				</a>
			{% endif %}
			<div class="dropdown-divider"></div>
			<a class="dropdown-item dfx" href="{{ logout_link }}">
				<div class="ecn">
					<i class="fa fa-sign-out"></i>
				</div>
				<div class="mr-4">{{ lang.log_out }}</div>
			</a>
		</div>
	</li>
{% else %}
	<script language="javascript">
		var set_login = 0;
		var set_pass  = 0;
	</script>
	<div style="display: none;background-color: #ffffff;" id="authm" class="p-0">
		<div class="row no-gutters">
			<div class="col-12 col-md-6 p-3 p-md-4">
				<div class="h5 text-center">{{ lang.theme.usermenu_login_title }}</div>
				<form class="py-3" name="login" method="post" action="{{ form_action }}" id="login">
					<div class="form-group">
						<label for="exampleFormControlInput1" class="f90">{{ lang.username }}</label>
						<input type="text" class="form-control" id="inputEmail" name="username" placeholder="{{ lang.username }}">
					</div>
					<div class="form-group">
						<label for="exampleFormControlInput1" class="f90">{{ lang.password }}</label>
						<input class="form-control" type="password" id="inputPassword" name="password" placeholder="{{ lang.password }}" >
					</div>
					<div class="custom-control custom-checkbox mb-3 mt-2">
						<input type="checkbox" value="1" name="login_not_save" class="custom-control-input" id="customCheck1">
						<label class="custom-control-label f90" for="customCheck1">{{ lang.remember_me }}</label>
					</div>
					<button type="submit" class="btn btn-primary btn-block px-3">{{ lang.login }}</button>
					<input type="hidden" name="redirect" value="{{ redirect }}" />
				</form>
			</div>
			<div class="col-12 col-md-6 p-3 p-md-4 authbg bgblur">
				<div class="d-flex flex-column justify-content-between h-100 rounded position-relative" style="z-index: 1;">
					<div class="text-center h5 align-self-start w-100">{{ lang.theme.usermenu_or }}</div>
					<div class="row mx-lg-n1">
						<a class="btn btn-sm btn-outline-secondary btn-block f90 mb-2" href="{{ reg_link }}">{{ lang.theme.usermenu_reg_link }}</a>
						<a class="btn btn-sm btn-outline-secondary btn-block f90 text-muted" href="{{ lost_link }}">{{ lang.theme.usermenu_lost_link }}</a>
					</div>
				</div>
			</div>
		</div>
	</div>
	<li class="nav-item py-3">
		<button type="button" id="auth" class="btn btn-primary px-3 py-2">
			<div class="d-flex align-items-center">
				<div class="ecn-l text-light">
					<i class="fa fa-user"></i>
				</div>
				<div>
					{{ lang.login }}
				</div>
			</div>
		</button>
	</li>
{% endif %}